﻿/*
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Portions created by the Initial Developer are
 * Copyright (C) 2012 the Initial Developer.
 * All Rights Reserved.
 *
 * The Original Code is "http://semi-frame.googlecode.com/svn/trunk/".
 *
 * The Initial Developer of the Original Code is the author below.
 */

/**
 * @file Validater.cs
 * @brief auto generated.
 * @author mornongcloud
 * @date 2011/07/21
 */


using System;
using System.Collections.Generic;
using System.Data;
using System.Windows.Forms;
using System.Linq;

namespace masterframe.model
{
    /// <summary>
    /// Validater class
    /// </summary>
    public class Validater
    {
        /// <summary>
        /// Validater setting
        /// </summary>
        public Dictionary<string, StValidate> config;

        /// <summary>
        /// setting structure
        /// </summary>
        public struct StValidate
        {
            /// <summary>
            /// item name
            /// </summary>
            public string name;
            /// <summary>
            /// data types
            /// </summary>
            public string type;
            /// <summary>
            /// 
            /// </summary>
            public int min;
            /// <summary>
            /// 
            /// </summary>
            public int max;

            /// <summary>
            /// 
            /// </summary>
            /// <param name="nm"></param>
            /// <param name="ty"></param>
            /// <param name="mi"></param>
            /// <param name="ma"></param>
            public StValidate(string nm, string ty, int mi, int ma)
            {
                this.name = nm;
                this.type = ty;
                this.min = mi;
                this.max = ma;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        public Validater()
        {
            //masterframe.util.ConfigUtil.GetSettingsList("VALIDATE");
            Dictionary<string, Object> dic = masterframe.util.ConfigUtil.GetSettings("VALIDATE", new StValidate());
            this.config = dic.ToDictionary(o => o.Key, o => (StValidate)o.Value);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="row"></param>
        /// <returns></returns>
        public string Validate(Column clmset, DataRow row)
        {
            foreach (StValidate valid in config.Values)
            {
                //var vl = row["MobileId"];
                string nm = valid.name;
                try
                {
                    if (row.IsNull(nm)) continue;
                }
                catch (Exception)
                {
                    continue;
                }
                var vl = row[nm];

                if (clmset.config.ContainsKey(nm)
                    && 0 < clmset.config[nm].name.Length)
                    nm = clmset.config[nm].name;

                if (valid.type.Contains("int"))
                {
                    int dm;
                    bool n = int.TryParse(vl.ToString().Trim(), out dm);
                    if (!n)
                    {
                        return nm + " is number.";
                    }
                    if (dm < valid.min)
                    {
                        return nm + " is more than " + valid.min.ToString() + ".";
                    }
                    if (valid.max < dm)
                    {
                        return nm + " is less than " + valid.max.ToString() + ".";
                    }

                }
                else if (valid.type.Contains("date"))
                {
                    int b = System.Text.Encoding.ASCII.GetByteCount(vl.ToString().Trim());
                    int min = valid.min;
                    int max = valid.max;
                    if (min < 8) min = 8;
                    if (19 < max) max = 19;
                    if (b < min)
                    {
                        return nm + "'s length is more than " + min.ToString() + ".";
                    }
                    if (max < b)
                    {
                        return nm + "'s length is less than " + max.ToString() + ".";
                    }
                    DateTime dt;
                    if (!DateTime.TryParse(vl.ToString(), out dt))
                    {
                        return nm + "is date type.";
                    }
                }
                else if (valid.type.Contains("time"))
                {
                    int b = System.Text.Encoding.ASCII.GetByteCount(vl.ToString().Trim());
                    int min = valid.min;
                    int max = valid.max;
                    if (min < 5) min = 5;
                    if (9 < max) max = 9;
                    if (b < min)
                    {
                        return nm + "'s length is more than " + min.ToString() + ".";
                    }
                    if (max < b)
                    {
                        return nm + "'s length is less than " + max.ToString() + ".";
                    }
                    DateTime dt;
                    if (!DateTime.TryParse("1999/01/01 " + vl.ToString(), out dt))
                    {
                        return nm + "is date type.";
                    }
                }
                else
                {
                    int b = System.Text.Encoding.ASCII.GetByteCount(vl.ToString());
                    if (b < valid.min)
                    {
                        return nm + "'s length is more than " + valid.min.ToString() + ".";
                    }
                    if (valid.max < b)
                    {
                        return nm + "'s length is less than " + valid.max.ToString() + ".";
                    }
                }
            }
            return "";
        }
    }
}
