﻿/*
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this file,
 * You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Portions created by the Initial Developer are
 * Copyright (C) 2012 the Initial Developer.
 * All Rights Reserved.
 *
 * The Original Code is "http://semi-frame.googlecode.com/svn/trunk/".
 *
 * The Initial Developer of the Original Code is the author below.
 */

/**
 * @file Entity.cs
 * @brief auto generated.
 * @author mornongcloud
 * @date 2011/07/21
 */

using System.Collections.Generic;
using System.Data;
using System.Windows.Forms;

namespace masterframe.model
{
    /// <summary>
    /// SqlServerEntityinstance 
    /// </summary>
    public class Entity : masterframe.model.entity.SqlServerEntity
    {
        /// <summary>
        /// DataTable
        /// </summary>
        public DataTable entities;

        /// <summary>
        /// Validater
        /// </summary>
        public Validater validater;

        /// <summary>
        /// 
        /// </summary>
        public Column columnsetting;

        /// <summary>
        /// instance with the data source
        /// </summary>
        /// <param name="p"></param>
        public Entity(string p)
            : base(p)
        {
            base.OpenSelect("select 1");// Connection test
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public DataTable GetTable(string sql)
        {
            var ret = base.OpenSelect(sql);

            return ret;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public string Load(string sql)
        {
            try
            {
                this.validater = new Validater();
                this.columnsetting = new Column();
            }
            catch (System.Exception e)
            {
                return "Fail to read config. [" + e.Message + "] ";
            }
            try
            {
                this.entities = this.GetTable(sql);

                if (0 == this.entities.Rows.Count) return " No data. ";
            }
            catch (System.Exception e)
            {
                return "Fail to read data. [" + e.Message + "] ";
            }
            return "";
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="tbl"></param>
        /// <returns></returns>
        public string Validate(DataTable tbl = null)
        {
            try
            {
                if (null == validater)
                    validater = new Validater();

                if (null == tbl) tbl = this.entities;

                int i = 0;
                int idx = 0;
                foreach (DataRow row in tbl.Rows)
                {
                    idx++;

                    if (row.RowState == System.Data.DataRowState.Deleted) continue; // delete rows

                    i++;

                    if (row.RowState == System.Data.DataRowState.Unchanged) continue;

                    if (tbl.Columns.Contains("EDIT"))
                        //row["EDIT"] = new masterframe.util.DateUtil().ToString();
                        row["EDIT"] = System.DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");

                    string val = validater.Validate(this.columnsetting, row);
                    if (0 < val.Length)
                        return val + "(" + i.ToString() + " rows) ";

                }
                return "";
            }
            catch (System.Exception e)
            {
                return "Fail to read data. [" + e.Message + "] ";
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public string Save()
        {
            //string err = this.Validate(this.entities);
            //if (0 < err.Length) return err;

            try
            {
                //if (!base.Update(this.entities)) return "Fail to update data.";
                base.Update(this.entities);

                //string sql_select = "insert into csk.Mobile (MobileId, Type, Number, Name) select MobileId, Type, Number, Name from csk.Vehicle where not exists (select 1 from csk.Mobile where csk.Mobile.MobileId = csk.Vehicle.MobileId)";
                //masterframe.model.entity.SqlServerEntity.Update(cnn, sql_select);
            }
            catch (System.Exception e)
            {
                return "Fail to update data. [" + e.Message + "]";
            }
            return "";
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public string InsertOrUpdate()
        {
            bool bl = false;
            try
            {
                bl = base.InsertOrUpdate(this.entities);
                //return this.InsertOrUpdateCurrentByMaster();
                if (!bl) return "No data for update.";
                return "";
            }
            catch (System.Exception e)
            {
                return "Fail to update data. [" + e.Message + "]";
            }
        }

        /// <summary>
        /// 連続削除に対応するため、KEY→位置を取り直す
        /// </summary>
        /// <param name="sql">delete from [PROC_PARAM] where [PROC]=@PROC and [PARAM]=@PARAM</param>
        /// <param name="rows"></param>
        /// <returns></returns>
        public string DeleteByKey(string sql, List<DataGridViewRow> rows)
        {
            try
            {
                //string sql_select = "delete from csk.Vehicle where MobileId=@MobileId";
                //string sql_select = "delete from [CIS].[dbo].[PROC_PARAM] where [PROC]=@PROC and [PARAM]=@PARAM";
                //int keycnt = masterframe.util.StringUtil.CountChar(sql, '@');
                int keycnt = CountChar(sql, '@');

                var delrows = new List<int>();

                int idx = -1;
                foreach (DataRow row in this.entities.Rows)
                {
                    idx++;
                    if (row.RowState == System.Data.DataRowState.Deleted) continue; // 削除済
                    if (row.RowState == System.Data.DataRowState.Added) continue;

                    //string ot1 = row["PROC"].ToString();
                    //if (int.TryParse(, out ot))
                    //{
                    for (int i = 0; i < rows.Count; i++)
                    {
                        bool hit = true; // 全キーがHITする？先頭は必ずキーでなければならない
                        for (int j = 0; j < keycnt; j++)
                        {
                            if (rows[i].Cells[j].Value.ToString() != row[j].ToString())
                            {
                                hit = false;
                                break;
                            }
                        }
                        if (hit)
                        {
                            delrows.Add(idx); //全キーがHIT
                            break;
                        }
                    }
                }

                if (0 == delrows.Count) return "";

                //delete
                //bool ret = masterframe.model.entity.SqlServerEntity.Delete(cnn, this.entities, delrows, sql);
                bool ret = this.Delete(this.entities, delrows, sql);

                return "";
            }
            catch (System.Exception e)
            {
                return "Fail to update data. [" + e.Message + "]";
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="s"></param>
        /// <param name="c"></param>
        /// <returns></returns>
        public static int CountChar(string s, char c)
        {
            return s.Length - s.Replace(c.ToString(), "").Length;
        }
    }
}
