#include "head.h"
#include <stdio.h>
#include <string.h>
extern struct biosinfo *basic;
extern struct wcontrol *window_control;
struct window *make_window(unsigned int x,unsigned int y,unsigned int xsize,unsigned int ysize,unsigned char *name)
{
  unsigned int i,j,k;
  for(k=0;k<MAXWINDOW;k++){
    if(window_control->window[k].use==WINDOW_NOT_USING){
      window_control->window[k].buffer=(unsigned short*)alloc4((struct manager *)(MANAGER_ADDR),xsize*ysize*2);
      window_control->window[k].x=x;
      window_control->window[k].y=y;
      window_control->window[k].xsize=xsize;
      window_control->window[k].ysize=ysize;
      window_control->window[k].task=0;
      window_control->window[k].use=WINDOW_USING;
      window_control->window[k].height=-1;
      window_control->window[k].inv=VISIBLE;
      strcpy(window_control->window[k].name,name);
      for(j=0;j<16;j++){
	for(i=0;i<xsize-30;i++){
	  window_control->window[k].buffer[j*xsize+i]=DARKMURASAKI;
	}
	for(;i<xsize;i++){
	  window_control->window[k].buffer[j*xsize+i]=DARKMIZU;
	}
      }
      for(;j<ysize;j++){
	for(i=0;i<xsize;i++){
	  window_control->window[k].buffer[j*xsize+i]=DARKHAI;
	}
      }
      return &window_control->window[k];
    }
  }
  return 0;
}

struct window *make_external_window(unsigned int x,unsigned int y,unsigned int xsize,unsigned int ysize,int invisible)
{
  int i;
  for(i=0;i<MAXWINDOW;i++){
    if(window_control->window[i].use==WINDOW_NOT_USING){
      window_control->window[i].buffer=(unsigned short *)alloc4((struct manager *)(MANAGER_ADDR),xsize*ysize*2);
      window_control->window[i].x=x;
      window_control->window[i].y=y;
      window_control->window[i].xsize=xsize;
      window_control->window[i].ysize=ysize;
      window_control->window[i].use=WINDOW_USING;
      window_control->window[i].task=0;
      window_control->window[i].height=-1;
      if(invisible!=VISIBLE){
	window_control->window[i].inv=invisible;
      }else{
	window_control->window[i].inv=VISIBLE;
      }
      return &window_control->window[i];
    }
  }
  return 0;
}
void move_window(struct window *handle,unsigned int x,unsigned int y)
{
  unsigned int beforex,beforey;
  if(handle->height>=0){
    beforex=handle->x;
    beforey=handle->y;
    /* Âl̕ۑ */
    handle->x=x;
    handle->y=y;
    /* Vl̕ۑ */
    refresh_map(beforex,
		beforey,
		beforex+handle->xsize,
		beforey+handle->ysize,
		0);
  
    refresh_map(handle->x,
		handle->y,
		handle->x+handle->xsize,
		handle->y+handle->ysize,
		handle->height);
    refresh_window_main(beforex,
			beforey,
			beforex+handle->xsize,
			beforey+handle->ysize,
			0,
			handle->height-1);

    refresh_window_main(handle->x,
			handle->y,
			handle->x+handle->xsize,
			handle->y+handle->ysize,
			handle->height,
			handle->height);
  }
  return;
}
void close_window(struct window *handle)
{
  if(handle->height>=0){
    switch_window(handle,-1);
  }
  handle->use=WINDOW_NOT_USING;
  return;
}
void refresh_window(struct window *window,int redrow_startx,int redrow_starty,int redrow_endx,int redrow_endy)
{
  if(window->height>=0){
    refresh_window_main(window->x+redrow_startx,
			window->y+redrow_starty,
			window->x+redrow_endx,
			window->y+redrow_endy,
			window->height,
			window->height);
  }
  return;
}
void write_title(struct window *handle,int state)
{
  int i,j;
  int shift=handle->xsize-30;
  if(state==0){
    /* ʏ` */
    for(j=0;j<16;j++){
      for(i=shift;i<shift+30;i++){
	if(handle->buffer[j*handle->xsize+i]!=KURO){
	  handle->buffer[j*handle->xsize+i]=DARKMIZU;
	}
      }
    }
  }else{
    for(j=0;j<16;j++){
      for(i=shift;i<shift+30;i++){
	if(handle->buffer[j*handle->xsize+i]!=KURO){
	  handle->buffer[j*handle->xsize+i]=DARKMURASAKI;
	}
      }
    }
  }
  refresh_window(handle,shift,0,shift+30,16);
}
struct window *make_window_apli(unsigned short *buffer,unsigned int xsize,unsigned int ysize,unsigned char *name)
{
  unsigned int i,j,k;
  for(k=0;k<MAXWINDOW;k++){
    if(window_control->window[k].use==WINDOW_NOT_USING){
      window_control->window[k].buffer=buffer;
      window_control->window[k].x=0;
      window_control->window[k].y=0;
      window_control->window[k].xsize=xsize;
      window_control->window[k].ysize=ysize;
      window_control->window[k].task=0;
      window_control->window[k].use=WINDOW_USING;
      window_control->window[k].height=-1;
      window_control->window[k].inv=VISIBLE;
      strcpy(window_control->window[k].name,name);
      for(j=0;j<16;j++){
	for(i=0;i<xsize-30;i++){
	  window_control->window[k].buffer[j*xsize+i]=DARKMURASAKI;
	}
	for(;i<xsize;i++){
	  window_control->window[k].buffer[j*xsize+i]=DARKMIZU;
	}
      }
      for(;j<ysize;j++){
	for(i=0;i<xsize;i++){
	  window_control->window[k].buffer[j*xsize+i]=DARKHAI;
	}
      }
      return &window_control->window[k];
    }
  }
  return 0;
}
void window_setbuf(struct window *window,unsigned short *buffer)
{
  int i,j;
  window->buffer=buffer;
  for(j=0;j<16;j++){
    for(i=0;i<window->xsize-30;i++){
      window->buffer[j*window->xsize+i]=DARKMURASAKI;
    }
    for(;i<window->xsize;i++){
      window->buffer[j*window->xsize+i]=DARKMIZU;
    }
  }
  for(;j<window->ysize;j++){
    for(i=0;i<window->xsize;i++){
      window->buffer[j*window->xsize+i]=DARKHAI;
    }
  }
  return;
}
void refresh_map(int vx0, int vy0, int vx1, int vy1, int h0)
{
  int h, bx, by, vx, vy, bx0, by0, bx1, by1, sid4, *p;
  unsigned char sid,*map = window_control->map;
  unsigned short *buf;
  struct window *sht;
  if (vx0 < 0) { vx0 = 0; }
  if (vy0 < 0) { vy0 = 0; }
  if (vx1 > basic->fullx) { vx1 = basic->fullx; }
  if (vy1 > basic->fully) { vy1 = basic->fully; }
  for (h = h0; h <= window_control->top; h++) {
    sht = window_control->window_pointer[h];
    sid = sht - window_control->window; /* ԒnZĂԍƂėp */
    buf = sht->buffer;
    bx0 = vx0 - sht->x;
    by0 = vy0 - sht->y;
    bx1 = vx1 - sht->x;
    by1 = vy1 - sht->y;
    if (bx0 < 0) { bx0 = 0; }
    if (by0 < 0) { by0 = 0; }
    if (bx1 > sht->xsize) { bx1 = sht->xsize; }
    if (by1 > sht->ysize) { by1 = sht->ysize; }
    if(sht->inv==VISIBLE){
      if ((sht->x & 3) == 0 && (bx0 & 3) == 0 && (bx1 & 3) == 0) {
	/* FȂp̍Łi4oCg^j */
	bx1 = (bx1 - bx0) / 4; /* MOV */
	sid4 = sid | sid << 8 | sid << 16 | sid << 24;
	for (by = by0; by < by1; by++) {
	  vy = sht->y + by;
	  vx = sht->x + bx0;
	  p = (int *) &map[vy * basic->fullx + vx];
	  for (bx = 0; bx < bx1; bx++) {
	    p[bx] = sid4;
	  }
	}
      } else {
	/* FȂp̍Łi1oCg^j */
	for (by = by0; by < by1; by++) {
	  vy = sht->y + by;
	  for (bx = bx0; bx < bx1; bx++) {
	    vx = sht->x + bx;
	    map[vy * basic->fullx + vx] = sid;
	  }
	}
      }
    }else{
      for (by = by0; by < by1; by++) {
	vy = sht->y + by;
	for (bx = bx0; bx < bx1; bx++) {
	  vx = sht->x + bx;
	  if (buf[by * sht->xsize + bx] !=sht->inv) {
	    map[vy * basic->fullx + vx] = sid;
	  }
	}
      }
    }
  }
  return;
}

void refresh_window_main(int vx0, int vy0, int vx1, int vy1, int h0, int h1)
{
  int h, bx, by, vx, vy, bx0, by0, bx1, by1, bx2, i, i1,*q, *r;
  unsigned short *buf,sid2,*o;
  unsigned char  *vram = basic->vram, *map = window_control->map, sid;
  struct window *sht;
  /* refresh͈͂ʊOɂ͂ݏoĂ␳ */
  if (vx0 < 0) { vx0 = 0; }
  if (vy0 < 0) { vy0 = 0; }
  if (vx1 > basic->fullx) { vx1 = basic->fullx; }
  if (vy1 > basic->fully) { vy1 = basic->fully; }
  for (h = h0; h <= h1; h++) {
    sht = window_control->window_pointer[h];
    buf = sht->buffer;
    sid = sht - window_control->window;
    /* vx0`vy1gāAbx0`by1tZ */
    bx0 = vx0 - sht->x;
    by0 = vy0 - sht->y;
    bx1 = vx1 - sht->x;
    by1 = vy1 - sht->y;
    if (bx0 < 0) { bx0 = 0; }
    if (by0 < 0) { by0 = 0; }
    if (bx1 > sht->xsize) { bx1 = sht->xsize; }
    if (by1 > sht->ysize) { by1 = sht->ysize; }
    /* 16rbgJ[ */
    if ((sht->x & 2) == 0) {
      /* 4oCg^ */
      i  = (bx0 + 1) / 2; /* bx02Ŋ́i[؂グj */
      i1 =  bx1      / 2; /* bx12Ŋ́i[؂̂āj */
      i1 = i1 - i;
      sid2 = sid | sid << 8;
      for (by = by0; by < by1; by++) {
	vy = sht->y + by;
	for (bx = bx0; bx < bx1 && (bx & 1) != 0; bx++) {	/* O̒[1oCg */
	  vx = sht->x + bx;
	  if (map[vy * basic->fullx + vx] == sid) {
	    *(unsigned short *)	&vram[(vy * basic->fullx + vx) * 2] =
	      buf[by * sht->xsize + bx];
	  }
	}
	vx = sht->x + bx;
	o = (unsigned short *) &map[vy * basic->fullx + vx];
	q = (int   *) &vram[(vy * basic->fullx + vx) * 2];
	r = (int   *) &buf[by * sht->xsize + bx];
	for (i = 0; i < i1; i++) {							/* 2̔{ */
	  if (o[i] == sid2) {
	    q[i] = r[i];
	  } else {
	    bx2 = bx + i * 2;
	    vx = sht->x + bx2;
	    if (map[vy * basic->fullx + vx + 0] == sid) {
	      *(unsigned short *)	&vram[(vy * basic->fullx + vx + 0) * 2] =
		buf[by * sht->xsize + bx2 + 0];
	    }
	    if (map[vy * basic->fullx + vx + 1] == sid) {
	      *(unsigned short *)	&vram[(vy * basic->fullx + vx + 1) * 2] =
		buf[by * sht->xsize + bx2 + 1];
	    }
	  }
	}
	for (bx += i1 * 2; bx < bx1; bx++) {				/* ̒[1oCg */
	  vx = sht->x + bx;
	  if (map[vy * basic->fullx + vx] == sid) {
	    *(unsigned short *)	&vram[(vy * basic->fullx + vx) * 2] =
	      buf[by * sht->xsize + bx];
	  }
	}
      }
    } else {
      /* 2oCg^ */
      for (by = by0; by < by1; by++) {
	vy = sht->y + by;
	for (bx = bx0; bx < bx1; bx++) {
	  vx = sht->x + bx;
	  if (map[vy * basic->fullx + vx] == sid) {
	    *(unsigned short *)	&vram[(vy * basic->fullx + vx) * 2] =
	      buf[by * sht->xsize + bx];
	  }
	}
      }
    }
  }
  return;
}
void switch_window(struct window *sht, int height)
{
  int h, old = sht->height; /* ݒO̍L */

  /* w肪Ⴗ⍂AC */
  if (height > window_control->top + 1) {
    height = window_control->top + 1;
  }
  if (height < -1) {
    height = -1;
  }
  sht->height = height; /* ݒ */

  /* ȉ͎sheets[]̕בւ */
  if (old > height) {	/* ȑOႭȂ */
    if (height >= 0) {
      /* Ԃ̂̂グ */
      for (h = old; h > height; h--) {
	window_control->window_pointer[h] = window_control->window_pointer[h - 1];
	window_control->window_pointer[h]->height = h;
      }
      window_control->window_pointer[height] = sht;
      refresh_map(sht->x, sht->y, sht->x + sht->xsize, sht->y + sht->ysize, height + 1);
      refresh_window_main(sht->x, sht->y, sht->x + sht->xsize, sht->y + sht->ysize, height + 1, old);
    } else {	/* \ */
      if (window_control->top > old) {
	/* ɂȂĂ̂낷 */
	for (h = old; h < window_control->top; h++) {
	  window_control->window_pointer[h] = window_control->window_pointer[h + 1];
	  window_control->window_pointer[h]->height = h;
	}
      }
      window_control->top--; /* \̉̂ŁAԏ̍ */
      if(sht!=window_control->window_pointer[0]&&sht!=window_control->window_pointer[window_control->top]){
      	/* }EXƔwiłȂƂmFĂ */
      	box(window_control->back_window,(window_control->top-2)*TASKBAR_CONTENTS_SIZE,0,(window_control->top-1)*TASKBAR_CONTENTS_SIZE+1,TASKBAR_WIDTH,TASKBAR_COLOR);
      }
      refresh_map(sht->x, sht->y, sht->x + sht->xsize, sht->y + sht->ysize, 0);
      refresh_window_main(sht->x, sht->y, sht->x + sht->xsize, sht->y + sht->ysize, 0, old - 1);
    }
  } else if (old < height) {	/* ȑOȂ */
    if (old >= 0) {
      /* Ԃ̂̂ */
      for (h = old; h < height; h++) {
	window_control->window_pointer[h] = window_control->window_pointer[h + 1];
	window_control->window_pointer[h]->height = h;
      }
      window_control->window_pointer[height] = sht;
    } else {	/* \Ԃ\Ԃ */
      /* ɂȂ̂グ */
      for (h = window_control->top; h >= height; h--) {
	window_control->window_pointer[h + 1] = window_control->window_pointer[h];
	window_control->window_pointer[h + 1]->height = h + 1;
      }

      window_control->window_pointer[height] = sht;
      window_control->top++; /* \̉̂ŁAԏ̍ */
      if(sht!=window_control->window_pointer[0]&&sht!=window_control->window_pointer[window_control->top]){
	box(window_control->back_window,
	    (window_control->top-1)*TASKBAR_CONTENTS_SIZE,
	    0,
	    (window_control->top)*TASKBAR_CONTENTS_SIZE,
	    TASKBAR_WIDTH,
	    TASKBAR_CONTENTS_COLOR
	    );
	box(window_control->back_window,
	    (window_control->top-1)*TASKBAR_CONTENTS_SIZE,
	    0,
	    (window_control->top-1)*TASKBAR_CONTENTS_SIZE+TASKBAR_SIDELINE_SIZE,
	    TASKBAR_WIDTH,
	    TASKBAR_SIDELINE_COLOR
	    );
	box(window_control->back_window,
	    (window_control->top)*TASKBAR_CONTENTS_SIZE-TASKBAR_SIDELINE_SIZE,
	    0,
	    (window_control->top)*TASKBAR_CONTENTS_SIZE,
	    TASKBAR_WIDTH,
	    TASKBAR_SIDELINE_COLOR
	    );
	print(window_control->back_window,
	      sht->name,
	      (window_control->top-1)*TASKBAR_CONTENTS_SIZE+TASKBAR_SIDELINE_SIZE,
	      0,
	      TASKBAR_CONTENTS_STR_COLOR
	      );
      }
    }
    refresh_map(sht->x, sht->y, sht->x + sht->xsize, sht->y + sht->ysize, height);
    refresh_window_main(sht->x, sht->y, sht->x + sht->xsize, sht->y + sht->ysize, height, height);
  }
  return;
}
void switch_window_top(struct window *sht)
{
  switch_window(sht,window_control->top);
  return;
}
void open_selectmenu(void)
{
  struct window *menu;
  int i;
  int menu_xsize=0,menu_ysize=0;
  for(i=1;i<window_control->top-1;i++){
    if(menu_xsize<strlen(window_control->window_pointer[i]->name)){
      menu_xsize=strlen(window_control->window_pointer[i]->name);
    }
    if(menu_ysize<strlen(window_control->window_pointer[i]->name)){
      menu_ysize=strlen(window_control->window_pointer[i]->name);
    }
  }
  menu=make_external_window(basic->fullx/2-menu_xsize*font_xsize/2,basic->fully/2-menu_ysize*font_ysize/2,menu_xsize*font_xsize,menu_ysize*font_ysize,-1);
  box(menu,0,0,menu_xsize*font_xsize,menu_ysize*font_ysize,DARKHAI);
  for(i=1;i<window_control->top-2;i++){
    print(menu,window_control->window_pointer[i]->name,0,(i-1)*font_ysize,SIRO);
  }
  set_window_to_keywin(menu);
}
void set_window_to_keywin(struct window *window)
{
  if(window_control->key_win!=0){
    keywin_off(window_control->key_win);
  }
  window_control->key_win=window;
  switch_window_top(window_control->key_win);
  keywin_on(window_control->key_win);
  return;
}
void press_tab_switch(void)
{
  int j;
  keywin_off(window_control->key_win);
  j=window_control->key_win->height-1;
  if(j==0){
    j=window_control->top-1;
  }
  window_control->key_win=window_control->window_pointer[j];
  keywin_on(window_control->key_win);
  return;
}
