#include "head.h"

extern struct biosinfo *basic;
extern struct tcontrol *timer_control;
extern struct wcontrol *window_control;
extern struct manager *memory;
extern struct mouse_dec *dec;
void init_pic(void)
{
  io_out_eight(pic0_imr,0xff);
  io_out_eight(pic1_imr,0xff);
  io_out_eight(pic0_icw1,0x11);
  io_out_eight(pic0_icw2,0x20);
  io_out_eight(pic0_icw3,1<<2);
  io_out_eight(pic0_icw4,0x01);
  io_out_eight(pic1_icw1,0x11);
  io_out_eight(pic1_icw2,0x28);
  io_out_eight(pic1_icw3,0x02);
  io_out_eight(pic1_icw4,0x01);
  io_out_eight(pic0_imr,0xfb);
  io_out_eight(pic1_imr,0xff);
}
void enable_keyboard(void)
{
  /* keyboard */
  wait_kbc_sendready();
  io_out_eight(port_keycmd,keycmd_write_mode);
  wait_kbc_sendready();
  io_out_eight(port_keydat,kbc_mode);
  return;
}
void enable_mouse(void)
{
  /* mouse */
  send_mousecmd(mousecmd_enable);
  dec->phase=0;
  return;
}
void enable_pit(void)
{
  /* pit start */
  io_out_eight(pit_ctrl,0x34);
  io_out_eight(pit_cnt0,0x9c);
  io_out_eight(pit_cnt0,0x2e);
  /* pit end */
  return;
}
void gdt_idt_init(void)
{
  int i;
  struct segment_descriptor *gdt = (struct segment_descriptor *)adr_gdt;
  struct gate_descriptor *idt = (struct gate_descriptor *)adr_idt;
  for(i=0;i<=limit_gdt/8;i++){
    set_segmdesc(gdt+i,0,0,0);
  }
  set_segmdesc(gdt+1,0xffffffff,0x00000000,ar_data32_rw);
  set_segmdesc(gdt+2,limit_botpak,adr_botpak,ar_code32_er);
  load_gdtr(limit_gdt,adr_gdt);
  for(i=0;i<=limit_idt/8;i++){
    set_gatedesc(idt+i,0,0,0);
  }
  load_idtr(limit_idt,adr_idt);
  /* gdtɊ֐o^ */
  set_gatedesc(idt+0x07,(int)asm_fpuhandler,2*8,ar_intgate32);
  set_gatedesc(idt+0x0c,(int)asm_stack_exception,16,ar_intgate32);
  set_gatedesc(idt+0x0d,(int)asm_general_exception_handler,16,ar_intgate32);
  set_gatedesc(idt+0x0e,(int)asm_pagingfalut_handler,16,ar_intgate32);
  set_gatedesc(idt+0x20,(int)asm_timer_handler,16,ar_intgate32);
  set_gatedesc(idt+0x21,(int)asm_keyboard_handler,16,ar_intgate32);
  set_gatedesc(idt+0x26,(int)asm_fdc_handler,16,ar_intgate32);
  set_gatedesc(idt+0x2c,(int)asm_mouse_handler,16,ar_intgate32);
  set_gatedesc(idt+0x40,(int)asm_hrb_api,16,ar_intgate32+0x60);
}
void set_segmdesc(struct segment_descriptor *sd,unsigned int limit,int base,int ar)
{
  if(limit>0xfffff){
    ar|=0x8000;
    limit/=0x1000;
  }
  sd->limit_low=limit&0xffff;
  sd->base_low=base&0xffff;
  sd->base_mid=(base>>16)&0xff;
  sd->access_right=ar&0xff;
  sd->limit_high=((limit>>16)&0x0f)|((ar>>8)&0xf0);
  sd->base_high=(base>>24)&0xff;
  return;
}
void set_gatedesc(struct gate_descriptor *gd,int offset,int selector,int ar)
{
  gd->offset_low=offset&0xffff;
  gd->selector=selector;
  gd->dw_count=(ar >> 8)&0xff;
  gd->access_right=ar&0xff;
  gd->offset_high=(offset>>16)&0xffff;
  return;
}

void window_control_init(void)
{
  int i;
  window_control=(struct wcontrol *)alloc4((struct manager *)(MANAGER_ADDR),sizeof (struct wcontrol));
  window_control->top=-1;
  for(i=0;i<MAXWINDOW;i++){
    window_control->window[i].use=0;
    window_control->window[i].buffer=0;
    window_control->window[i].x=0;
    window_control->window[i].y=0;
    window_control->window[i].xsize=0;
    window_control->window[i].ysize=0;
    window_control->window[i].height=0;
    window_control->window[i].task=0;
    window_control->window[i].inv=0;
  }
  window_control->map=(unsigned char *)alloc4((struct manager *)(MANAGER_ADDR),basic->fullx*basic->fully);
  window_control->key_win=0;
}
void timer_control_init(void)
{
  int i;
  struct timer *t;
  timer_control=(struct tcontrol *)alloc4((struct manager *)(MANAGER_ADDR),sizeof (struct tcontrol));
  timer_control->count=0;
  for(i=0;i<MAXTIMER;i++){
    timer_control->timer[i].flag=TIMER_NOT_USING;
  }
  t=make_timer();
  t->timeout=0xffffffff;
  t->flag=TIMER_FLAG_USING;
  t->next=0;
  timer_control->t0=t;
  timer_control->next=0xffffffff;
  return;
}

void wait_kbc_sendready(void)
{
  for(;;){
    if((io_in_eight(port_keysta)&keysta_send_notready)==0){
      break;
    }
  }
  return;
}

int mouse_decode(struct mouse_dec *dec,int harddata)
{
  if(dec->phase==0){
    if(harddata==0xfa){
      dec->phase=1;
    }
    return 0;
  }else if(dec->phase==1){
    if((harddata&0xc8)==0x08){
      dec->buf[0]=harddata;
      dec->phase=2;
    }
    return 0;
  }else if(dec->phase==2){
    dec->buf[1]=harddata;
    dec->phase=3;
    return 0;
  }else if(dec->phase==3){
    dec->buf[2]=harddata;
    dec->phase=1;
    dec->left_button=dec->buf[0]&0x07&0x01;

    dec->right_button=dec->buf[0]&0x07&0x02;
    dec->middle_button=dec->buf[0]&0x07&0x04;
    dec->x=dec->buf[1];
    dec->y=dec->buf[2];
    if((dec->buf[0]&0x10)!=0){
      dec->x|=0xffffff00;
    }
    if((dec->buf[0]&0x20)!=0){
      dec->y|=0xffffff00;
    }
    dec->y=-dec->y;
    return 1;
  }
  return -1;
}
void send_mousecmd(unsigned char data)
{
  wait_kbc_sendready();
  io_out_eight(port_keycmd,keycmd_sendto_mouse);
  wait_kbc_sendready();
  io_out_eight(port_keydat,data);
  return;
}
