#include "head.h"
#include <stdio.h>
extern struct tcontrol *timer_control;
extern struct TASKCTL *task_control;
void keyboard_handler(int *esp)
{
  int data;
  io_out_eight(pic0_ocw2,0x61);
  data=io_in_eight(port_keydat);
  fifo_in(&(task_control->task_keyboard->fifo),data);
  return;
}
void mouse_handler(int *esp)
{
  int data;
  io_out_eight(pic1_ocw2,0x64);
  io_out_eight(pic0_ocw2,0x62);
  data=io_in_eight(port_keydat);
  fifo_in(&(task_control->task_mouse->fifo),data);
  return;
}
void timer_handler(int *esp)
{
  char ts=0;
  struct timer *timer;
  io_out_eight(pic0_ocw2,0x60);
  timer_control->count++;
  if(timer_control->next>timer_control->count){
    return;
  }
  timer=timer_control->t0;
  for(;;){
    if(timer->timeout>timer_control->count){
      break;
    }
    timer->flag=TIMER_FLAG_ALLOC;
    if(timer!=timer_control->multitask_timer){
      fifo_in(timer->fifo,timer->data);
    }else{
      ts=1;
    }
    timer=timer->next;
  }
  timer_control->t0=timer;
  timer_control->next=timer->timeout;
  if(ts!=0){
    taskswitch();
  }
  return;
}
void athlon(int *esp)
{
  io_out_eight(pic0_ocw2, 0x67); /* IRQ-07tPICɒʒm */
  return;
}
int *general_exception_handler(int *esp)
{
  struct TASK *task=task_now();
  struct CONSOLE *cons=task->cons;
  char s[30];
  print_cons(cons,"\nGeneral Protected Exception\n",SIRO);
  sprintf(s,"EIP=%08x\n",esp[11]);
  print_cons(cons,s,SIRO);
  return &(task->tss.esp0);
}
int *stack_exception(int *esp)
{
  struct TASK *task=task_now();
  struct CONSOLE *cons=task->cons;
  char s[30];
  print_cons(cons,"\nStack Exception\n",SIRO);
  sprintf(s,"EIP=%08x\n",esp[11]);
  print_cons(cons,s,SIRO);
  return &(task->tss.esp0);
}
int *fpuhandler(int *esp)
{
  struct TASK *task=task_now();
  io_cli();
  clts();
  if(task_control->task_fpu!=task){
    if(task_control->task_fpu!=0){
      fnsave(task_control->task_fpu->fpu);
    }
    frstor(task->fpu);
    task_control->task_fpu=task;
  }
  io_sti();
  return 0;
}
void fdc_handler(int *esp)
{
  io_in_eight(0x03f4);
  io_out_eight(0x0020, 0x66);
  fifo_in(&(task_control->task_fdc->fifo), 3);
  return;
}
void pagingfalut_handler(int *esp)
{
/*   y[WtHg̃G[R[h */
/* rbg   */
/* 0 	 	0Fy[Wɑ݂Ȃ̂ŁAy[WtHg܂ */
/*              1Fy[W̃ANZXxȉ̓ŃANZX̂ŁAy[WtHg܂ */
/* 1 	 	0Fy[WtHgƂȂANZX́Aǂݍ݂ł */
/*              1Fy[WtHgƂȂANZX́A݂ł */
/* 2 	 	0Fy[WtHgƂȂANZX́Axōs܂ */
/*              1Fy[WtHgƂȂANZX́A[Uxōs܂ */
/* 3 	 	0Fy[WtHǵAPDE̗\rbg1ɃZbgꂽł͂܂ */
/*              1Fy[WtHǵAPDE̗\rbg1ɃZbgꂽł  */
  int *esp2=esp-4;
  char s[10];
  sprintf(s,"%d %d %d %d",(*esp2)&0x01,(*esp2)&0x02,(*esp2)&0x03,(*esp2)&0x04);
  dprint(s,0,0,SIRO);
  return;
}
