/*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.lang.Class.declare("maskat.widget.html.Div")
	.extend("maskat.widget.html.HTMLWidget", {

    createWidget: function(parent) {
		var div = document.createElement("div");
		div.className = this.className;
		div.style.position = this.position || "absolute";
		div.style.left = this.left + "px";
		div.style.top = this.top + "px";
		div.style.whiteSpace = "nowrap";
		div.innerHTML = this.element || "";

		parent.getElement().appendChild(div);
		this.element = div;
    },
    
	getValue: function(){
		return this.element.innerHTML;
	},

	setValue: function(value){
		this.element.innerHTML = value;
	}

});
/*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.lang.Class.declare("maskat.widget.html.HTMLWidget")
	.extend("maskat.layout.Widget", {

	dispose: function() {
		maskat.lang.Object.dispose(this);
	},

	getWidget: function() {
		return this;
	},

	getWidgetId: function() {
		return this.name;
	},

	getElement: function() {
		return this.element;
	},

	setParent: function(parent){
		if (this.parent == parent) {
			return;
		}
		this.parent = parent;
		parent.getElement().appendChild(this.element);
	}


});
/*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.lang.Class.declare("maskat.widget.html.HTMLWidgetLibrary")
	.extend("maskat.layout.WidgetLibrary", {

	getBindingConfiguration: function() {
		return {
			javaScriptGlobal: {
				type: maskat.widget.html.Script,
				children: {
					"#cdata-section": { property: "text" }
				}
			},
			
			javaScript: {
				type: maskat.widget.html.Script,
				children: {
					"#cdata-section": { property: "text" }
				}
			},
			
			divHtml: {
				type: maskat.widget.html.Div,
				attributes: {
					name: { type: "string" , required: true  },
					top: { type: "number" , required: true  },
					left: { type: "number" , required: true  },
					className: { type: "string" },
					position: {
						type: "enum",
						values: [ "static", "relative", "absolute" ]
					}
				},
				children: {
					"#cdata-section": { property: "element" }
				}
			},
	
			iFrame: {
				type: maskat.widget.html.IFrame,
				attributes: {
					name: { type: "string" , required: true  },
					top: { type: "number" , required: true },
					left: { type: "number" , required: true },
					width: { type: "number" },
					height: { type: "number" },
					url: { type: "string" ,  defaultValue:"about:blank" }
				}
			}
		};
	}

});
/*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.lang.Class.declare("maskat.widget.html.HTMLWidgetPlugin")
	.extend("maskat.core.Plugin", {

	_static: {
		initialize: function() {
			maskat.core.Plugin.register(this);
		}
	},

	getPluginId: function() {
		return "html";
	},

	getVersion: function() {
		return "1.0.0.v20080521";
	},

	start: function() {
		var reader = maskat.layout.LayoutXMLReader.getInstance();
		var library = new maskat.widget.html.HTMLWidgetLibrary();
		reader.addWidgetLibrary(library);
	}

});
/*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.lang.Class.declare("maskat.widget.html.IFrame")
	.extend("maskat.widget.html.HTMLWidget", {

    createWidget: function(parent) {
		var iframe = document.createElement("iframe");
		iframe.style.position = "absolute";
		iframe.style.top = this.top;
		iframe.style.left = this.left;
		iframe.style.width = this.width;
		iframe.style.height = this.height;
		iframe.src = this.url;

		parent.getElement().appendChild(iframe);		
		this.element = iframe;
    },

	getValue: function(){
		return this.element.src;
	},

	setValue: function(value){
		if (value) {
			this.element.src = value;
		}
	}

});
/*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.lang.Class.declare("maskat.widget.html.Script")
	.extend("maskat.widget.html.HTMLWidget", {

	createWidget: function(parent) {
		maskat.app.loadJavaScriptFromString(this.text, false);
	},

	setParent: function(parent){
		if (this.parent == parent) {
			return;
		}
		this.parent = parent;
	}

});
