/*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.lang.Object.populate(maskat, {

	appInit: function(){
		maskat.core.Application.bootstrap();
	},

	loadLayoutFile: function(uri, element, visible){
		var regexp = /document\.getElementById\((['"])(.*)\1\)/;

		if (typeof(element) == "string") {
			var match = element.match(regexp);
			if (match) {
				element = document.getElementById(RegExp.$2);
			} else {
				element = document.getElementById(element);
			}
		}

		visible = visible || (arguments.length < 3);
		var layout = maskat.app.loadLayout(uri, null, element, visible); 

		this.lastLoadedLayout = layout;
	},

	showLayout: function(layoutId){
		var layout = maskat.app.getLayout(layoutId);
		if (layout) {
			layout.setVisible(true);
		}
	},
	
	hideLayout: function(layoutId){
		var layout = maskat.app.getLayout(layoutId);
		if (layout) {
			layout.setVisible(false);
		}
	},
	
	removeLayout: function(layoutId){
		maskat.app.unloadLayout(layoutId);
	},

	loadEventFile: function(uri){
		var layout = this.lastLoadedLayout;
		if (layout) {
			/* 直前にロードしたレイアウトとディスパッチャを対応付ける */
			var dispatcher = maskat.event.EventXMLReader.getInstance().load(uri);
			layout.addEventListener(dispatcher);

			this.lastLoadedLayout = null; 

			/*
			 * レイアウトの onload イベントは maskat.loadLayoutFile() の時点で
			 * 発生済みのため、ここで疑似的に再発生させる
			 */
			dispatcher.handleEvent(new maskat.event.Event(layout, layout, "onload"));
		}
	},

	loadJSFile: function(uri){
		maskat.app.loadJavaScript(uri, false);
	},
	
	loadJSSrc: function(source){
		maskat.app.loadJavaScriptFromString(source, false);
	},

	loadCSSFile: function(uri){
		maskat.app.loadStyleSheet(uri);
	},
	
	getFWLog: function(){
		return maskat.log.LogFactory.getLog("maskat.framework");
	},
	
	getCMULog: function(){
		return maskat.log.LogFactory.getLog("maskat.comm");
	},

	getAppLog: function(){
		return maskat.log.LogFactory.getLog("maskat.application");
	}

});
/*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.lang.Class.declare("maskat.compat.Maskat14SupportPlugin")
	.extend("maskat.core.Plugin", {

	_static: {
		initialize: function() {
			maskat.core.Plugin.register(this);
		}
	},

	getPluginId: function() {
		return "compat";
	},

	getVersion: function() {
		return "1.0.0.v20080521";
	},

	getDependencies: function() {
		return [ "rialto", "html" ];
	},

	isLoaded: function() {
		return this.loaded;
	},

	load: function() {
		this.loaded = true;

		if (window.onload) {
			this.onload = window.onload;
			window.onload = null;
			try {
				delete window.onload;
			} catch (e) { /* suppress */ }
		}
	},

	start: function() {
		var reader = maskat.layout.LayoutXMLReader.getInstance();
		reader.addWidgetLibrary(new maskat.layout.LayoutFactory());
		reader.addWidgetLibrary(new maskat.widget.compat.CompatWidgetLibrary());

		maskat.layouts = maskat.app.layouts;

		if (this.onload) {
			this.onload();
		}
	}

});
/*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.lang.Class.declare("maskat.widget.compat.CompatWidgetLibrary")
	.extend("maskat.layout.WidgetLibrary", {

	getBindingConfiguration: function() {
		var config = {
			confirmDialog: {
				type: maskat.widget.compat.ConfirmDialog,
				attributes: {
					name: { type: "string", required: true },
					title: { type: "string" },
					message: { type: "string" },
					btnOKTxt: { type: "string" },
					btnCancelTxt: { type: "string" },
					btnOnFocus: { type: "number", defaultValue: 2},
					okFunc: { type: "function", property: "onOK" },
					cancelFunc: { type: "function", property: "onCancel" }
				}
			},

			endDialog: {
				type: maskat.widget.compat.EndDialog,
				attributes: {
					name: { type: "string", required: true },
					message: { type: "string" , required: true }
				}
			}
		};
		return config;
	}


});
  /*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.lang.Class.declare("maskat.widget.compat.ConfirmDialog")
	.extend("maskat.widget.rialto.RialtoWidgetWrapper", {

    createWidget: function(parent) {
    	var width = getTailleTexte(this.title) + 40;
		if (width < 300) {
			width = 300;
		}
	
		/* ダイアログとして表示するポップアップウィンドウを生成 */
		var popup= new rialto.widget.PopUp(
			this.name,
			0,
			0,
			width,
			50,
			null,
			this.title,
			"Gris",
			{ withCloseButon: false });
	    this.widget = popup;
		this.setVisible(false);

		var div = document.createElement("div");
		div.innerHTML = this.message;
		popup.getHtmlCont().appendChild(div);

		/* OK ボタンを生成 */
	    var self = this;
		var okButton = new rialto.widget.Button(
			25,
			parseInt(width) / 2 - 114,
			this.btnOKTxt,
			this.btnOKTxt,
			popup);
		okButton.onclick = function(e) {
			popup.setVisible(false);
			if (self.onOK) {
				self.onOK();
			}
			self.proceed();
		}
		okButton.getHtmlExt().tabIndex = 32767;

		/* キャンセルボタンを生成 */
		var cancelButton = new rialto.widget.Button(
			25,
			parseInt(width) / 2 + 6,
			this.btnCancelTxt,
			this.btnCancelTxt,
			popup);
		cancelButton.onclick = function(e) {
			popup.setVisible(false);
			if (self.onCancel) {
				self.onCancel();
			}
		}
		cancelButton.getHtmlExt().tabIndex = 32767;
		
		var keyHandler = function(event) {
			var element = event.currentTarget || event.srcElement;
			switch (event.keyCode) {
			case 13:
			case 32:
				element.onclick();
				break;
			case 9:
				if (event.preventDefault) {
					event.preventDefault();
				} else {
					event.returnValue = false;
				}
				if (event.stopPropagation) {
					event.stopPropagation();
				} else {
					event.cancelBubble  = true;
				}
			case 37:
			case 39:
				if (okButton.getHtmlExt() == element) {
					cancelButton.getHtmlExt().focus();
				} else {
					okButton.getHtmlExt().focus();
				}
				break;
			}
			return false;
		};
		maskat.util.CrossBrowser.addEventListener(
			okButton.getHtmlExt(), "keydown", keyHandler);
			
		maskat.util.CrossBrowser.addEventListener(
			cancelButton.getHtmlExt(), "keydown", keyHandler);
    },

	setParent: function(parent) {
		if (this.parent == parent) {
			return;
		}
		this.parent = parent;
	},

	setVisible: function(visible) {
		if (visible) {
			/* ブラウザウインドウの中央に表示する */
			this.widget.setTop((document.body.clientHeight - 240) / 2);
			this.widget.setLeft((document.body.clientWidth - this.widget.width) / 2);
		}
		this.widget.setVisible(visible);
		
		/*
		 * 指定されたボタンにフォーカスを設定
		 * IEはフォーカスが移動できる状態でないとエラーとなる
		 */
		if (visible) {
			if (this.btnOnFocus == 1){
				this.widget.arrChild[0].getHtmlExt().focus();
			} else {
				this.widget.arrChild[1].getHtmlExt().focus();
			}
		}
	},

	proceed: function() {
		/* NOP */
	}
});
/*
 * Copyright (c)  2006-2007 Maskat Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
maskat.lang.Class.declare("maskat.widget.compat.EndDialog")
	.extend("maskat.widget.rialto.RialtoWidgetWrapper", {

    createWidget: function(parent) {
    	/* NOP */
    },

	setParent: function(parent) {
		if (this.parent == parent) {
			return;
		}
		this.parent = parent;
	},

	setVisible: function(visible) {
		/*
		 * アラートウインドウは閉じるとインスタンスが削除されるため、表示の
		 * たびに生成する
		 */
		if (visible) {
			this.widget = new rialto.widget.Alert(this.message);
			var button = this.widget.BQUIT.getHtmlExt();
			button.tabIndex = 32767;
			button.focus();
			
			var keyHandler = function(event) {
				var element = event.currentTarget || event.srcElement;
				switch (event.keyCode) {
				case 13:
				case 32:
					element.onclick();
					break;
				case 9:
					if (event.preventDefault) {
						event.preventDefault();
					} else {
						event.returnValue = false;
					}
					if (event.stopPropagation) {
						event.stopPropagation();
					} else {
						event.cancelBubble  = true;
					}
					break;
				}
				return false;
			};
			maskat.util.CrossBrowser.addEventListener(
				button, "keydown", keyHandler);
				
		} else {
			this.widget.fen.setVisible(false);
		}
	}
});
