package org.maskat.demo.chatclient;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class MsgObject
{
	private String owner;
	private String msg;
	
	private Date 	timeRcvd;
	
	private List<String> listUsersMsgNotRcvd = Collections.synchronizedList(
			new LinkedList<String>());
	
	MsgObject(String owner, String nMsg, Collection<String> loggedInUsers)
	{
		msg 		= nMsg;
		this.owner	= owner;
		
		timeRcvd 	= new Date(System.currentTimeMillis());
		
		listUsersMsgNotRcvd.addAll(loggedInUsers);
		if (!loggedInUsers.contains(owner))
		{
			listUsersMsgNotRcvd.add(this.owner);
		}
	}
	
	public boolean addSingleReceiver(String newReceiver)
	{
		return listUsersMsgNotRcvd.add(newReceiver);
	}
	
	public boolean addReceivers(Collection<String> loggedInUsers)
	{	
		return listUsersMsgNotRcvd.addAll(loggedInUsers);
	}
	
	
	public boolean removeReceiver(String rmvReceiver)
	{
		return listUsersMsgNotRcvd.remove(rmvReceiver);		
	}
	
	public String getMsgAsXMLString()
	{
		StringBuffer sbMsg = new StringBuffer();
		
		sbMsg.append("<message>\n\t\t\t");
			sbMsg.append("<owner>" 		+ owner 	+ "</owner>\n\t\t\t");
			sbMsg.append("<content>" 	+ msg 		+ "</content>\n\t\t\t");
			sbMsg.append("<timestamp>" 	+ timeRcvd 	+ "</timestamp>\n\t\t");
		sbMsg.append("</message>\n\t");
		
		return sbMsg.toString();
	}
	
	public boolean isNotSend()
	{
		return listUsersMsgNotRcvd.isEmpty();
	}

	public boolean isAddressedFor(String receiver)
	{
		return listUsersMsgNotRcvd.contains(receiver);
	}
	
	public String toString()
	{
		StringBuffer receiver = new StringBuffer();
		for(String user : listUsersMsgNotRcvd)
		{
			receiver.append(user + " ");
		}
		return "Sender: " + owner + "\n Content: " + msg + "\n TS: " + timeRcvd + "/n" + receiver;
		
	}
}
