package org.maskat.demo.chatclient;

import java.util.LinkedList;

/**
 * @author  Administrator
 */
public class MessageExchangeLogic
{
	MyChatClientData msgExDataObj = null;

	public void setMsgExDataObject(MyChatClientData dataObj)
	{
		msgExDataObj = dataObj;
	}

	public boolean addNewMsgToQueue(String[] newMsgArray)
	{
		return msgExDataObj.addNewMsgToQueue(newMsgArray);
	}

	public String getMsgsFromQueue(String receiver)
	{
		String msgs;
		
		LinkedList<MsgObject> msgQueue = null; 

		try 
		{
			msgQueue = msgExDataObj.getMsgsForUser(receiver);
			
			if (!msgQueue.isEmpty())
			{
				System.out.println("THERE ARE: " + msgQueue.size() + " FOR THE USER");
				msgs = getMsgsAsXML(msgQueue);
				
				System.out.println("###########################################\n################################################\n" +
						  msgs);
				return msgs;
			}
			
			return "";
		}
		catch (NullPointerException e)
		{
			return "";
		}
	}
	
	public String getMsgsAsXML(LinkedList<MsgObject> msgQueue)
	{
		StringBuffer sbMessages = new StringBuffer();
		
		for(MsgObject msgObj : msgQueue)
		{
			sbMessages.append(msgObj.getMsgAsXMLString());
		}
				
		return sbMessages.toString();
	}

	public MyChatClientData getMsgExDataObject()
	{
		return msgExDataObj;
	}

	public void cleanSentMsgs()
	{
		msgExDataObj.cleanSentMsgs();
		
	}

}
