maskat.syntax["iFrame"]= {
    name: {type: "string"},
    top: {type: "number"},
    left: {type: "number"},
    width: {type: "string"},
    height: {type: "string"},
    url: {type: "string"},
    parent: {type: "object"}
  };
  
maskat.transIFrameTag = function(pathObjArray, domElem){
  var attr = {};

  //// 属性の取得
  maskat.receiveAttributes(domElem, attr);

  //// 前変換

  // pathObjArrayの要素を降順に走査し、isContainerプロパティがtrue
  // のオブジェクトのgetRefObjメソッドの戻り値を取得する
  var refObjName=null;
  for (var i = pathObjArray.length - 1; i >= 0; i--){
    if (pathObjArray[i].isContainer){
      refObjName = pathObjArray[i].getRefObj();
      break;
    }
  }

  attr["parent"] = refObjName;

  var strObjPar = maskat.composeParam(domElem, attr);

  var output = attr.name + " = new maskat.widget.IFrame(" + strObjPar + ");\n";
  output += "layoutObj.components[\""+attr.name + "\"]="+attr.name+";\n";
  return output;
}

maskat.widget.IFrame = function(objPar){
    //if parent is not specified then create a div DOM object as the parent
    var parentObj = objPar.parent;
    if (parentObj==null){
        parentObj = document.body;
        objPar.parent = document.body;
    }
	objPar.type = "iFrame";
    this.base=rialto.widget.AbstractComponent;
    this.base(objPar);
    this.method = objPar.method;
    this.parent = objPar.parent;
    
    // マスカット用
    this.isSingle = true;
    //this.isMulti = true; // 複数データの場合
    
    // フレーム設定
    objPar["title"] = "";
    objPar["initial"] = true;
    objPar["dynamic"] = false;
    objPar["position"] = "absolute";
    objPar["draggable"] = false;
    objPar["boolMaxi"] = false;
    this.frame = new rialto.widget.Frame(objPar);
    this.frame.cadre.style.overflow="hidden";
    this.iframe = document.createElement("iframe");
    this.iframe.id = this.id + "_iFrame";
    this.iframe.style.width = this.width;
    this.iframe.style.height = this.height;
    if(objPar.url){
	   	this.iframe.src = objPar.url;
    }
    this.frame.add(this.iframe);
    this.parent.add(this.frame);
}

maskat.widget.IFrame.prototype = new rialto.widget.AbstractComponent;

// 値の設定（シングル版）
maskat.widget.IFrame.prototype.setSingleValue = function(val){
	if(val){
		this.iframe.src = val;
    }
}

// 値の設定（マルチ版）
maskat.widget.IFrame.prototype.setMultiValue = function(val){
	// 未使用
}

// 値の取得（シングル版）
maskat.widget.IFrame.prototype.getSingleValue = function(){
	return this.iframe.src;
}

maskat.widget.IFrame.prototype.remove = function(){
	this.frame.remove();
}
