package org.maskat.core.node;

/**
 * ルートノード
 * <pre>
 * ノードの親ノードを表す。
 * <code>
 * Node leaf = new LeafNode("tag", "10");
 * String xml = leaf.getXML();
 * </code>
 * の場合、xmlは<code>"&lt;tag&gt;10&lt;/tag&gt;"</code>となる。
 * <code>"&lt;parent&gt;&lt;tag&gt;10&lt;/tag&gt;&lt;parent&gt;"</code>
 * と、parentタグで囲ったXMLを得たい場合、
 * <code>
 * Node leaf = new LeafNode("tag", "10");
 * String xml = new ParentNode("parent", leaf).getXML();
 * </code>
 * とする。
 */
public class ParentNode implements Node {

	private Node child;
	
	private String nodeName;
	
	/**
	 * コンストラクタ
	 * @param nodeName ノード名
	 * @param child 子ノード
	 */
	public ParentNode(String nodeName, Node child) {
		this.child = child;
		this.nodeName = nodeName;
	}
	
	/**
	 * @see org.maskat.core.node.Node#getXML()
	 */
	public String getXML() {
		return "<" + nodeName + ">" + child.getXML() + "</" + nodeName + ">";
	}
}