package org.maskat.core.gen;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

/**
 * DTD無視クラス
 * <pre>
 * XMLを読み込み、<b>!DOCTYPE</b>タグを取り除く
 * </pre>
 */
public class DtdIgnore {

	private StringBuffer fileContent;

	/**
	 * コンストラクタ
	 * @param path 対象XMLパス
	 * @throws IOException
	 */
	public DtdIgnore(String path) throws IOException {
		fileContent = new StringBuffer();
		BufferedReader reader = null;
		try {
			reader = new BufferedReader(new FileReader(path));
			String line = null;
			while ( null != (line = reader.readLine()) ) {
				fileContent.append(line);
			}
		} finally {
			if (null != reader) {
				reader.close();
			}
		}
	}
	
	/**
	 * !DOCTYPEタグを取り除く
	 */
	private void omitsDtd() {
		int start = fileContent.indexOf("<!DOCTYPE");
		if (-1 == start) {
			return;
		}
		int end = fileContent.indexOf(">", start);
		fileContent.delete(start, end + 1);
		omitsDtd();
	}
	
	/**
	 * DTD定義を取り除いたXMLのReaderを取得
	 * @return Reader
	 */
	public Reader getReader() {
		omitsDtd();
		return new StringReader(fileContent.toString());
	}
}
