package org.maskat.core;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

/**
 * Maskat設定情報
 */
public class MaskatConfig {
	
	private final String srcPath;
	private final String xmlPath;
	private final String changeLine;
	private final String charSet;
	
	public MaskatConfig() throws FileNotFoundException, IOException {
		String propertyFilePath = ClassLoader.getSystemResource("maskat.property").getPath();
		Properties prop = new Properties();
		prop.load(new FileInputStream(propertyFilePath));
		srcPath = (String) prop.get("generate.src.path");
		xmlPath = (String) prop.get("generate.xml.path");
		changeLine = (String) prop.get("generate.code.chageline");
		charSet = (String) prop.get("generate.code.charset");
	}

	public String getChangeLine() {
		return changeLine;
	}

	public String getSrcPath() {
		return srcPath;
	}

	public String getXmlPath() {
		return xmlPath;
	}

	public String getCharSet() {
		return charSet;
	}
}
