package org.maskat.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.xml.sax.SAXException;

/**
 * makatANVT[ubg
 * @author pluswing
 */
public class MaskatActionServlet extends HttpServlet {

	private static final long serialVersionUID = 8767864012181317465L;

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		doPost(request, response);
	}
	
	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {

		try {
			request.setCharacterEncoding("UTF-8");
			MaskatRequest maskatRequrst = MaskatRequestBuilder.build(request);

			String packageName = request.getHeader("maskat_layoutID");
			String classname = request.getHeader("maskat_componentID");
			String methodName = request.getHeader("maskat_eventID");
			MaskatResponseBuilder builder = new MaskatResponseBuilder("maskat");

			Class executeClass = Class.forName(packageName + "." + classname);
			Object execObj = executeClass.newInstance();
			
			Method execMethod = executeClass.getMethod(methodName, new Class[] { MaskatRequest.class, MaskatResponseBuilder.class });
			execMethod.invoke(execObj, new Object[]{maskatRequrst, builder});

			response.setContentType("text/xml;charset=UTF-8");
			PrintWriter out = response.getWriter();
			out.println(builder.getResponce());
			
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
		} catch (SAXException e) {
			e.printStackTrace();
		}
	}
}
