/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.ide.gef.figure;

import java.util.Iterator;
import java.util.List;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;

public class SplitterFigure extends Label {

	/**
	 * w肳ꂽCfbNXsplitPage\ɂ<br>
	 * splitPage͔\ɂ
	 * 
	 * @param idx
	 */
	public void showSplitPage(int idx) {
		List childrenFigure = getChildren();
		int figureIdx = 0;
		for (Iterator it = childrenFigure.iterator(); it.hasNext();) {
			IFigure figure = (IFigure) it.next();
			if (figure instanceof SplitPageFigure) {
				if (((SplitPageFigure) figure).getIdx() == idx) {
					figure.setVisible(true);
				} else {
					figure.setVisible(false);
				}
				figureIdx++;
			}
		}
	}
}