/*
 * Copyright 2006 Mask@ Project.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maskat.framework.screendef;

import java.util.Map;

import org.maskat.framework.BasicDef;

/**
 * The instance of this class represents the outer-most node of the layout
 * definition xml (&lt;maskat&gt;)
 * 
 * @author shengshen
 * 
 */
public class MaskatDef extends BasicDef {
	private Map namespaces;

	public Map getNamespaces() {
		return namespaces;
	}

	public void setNamespaces(Map namespaces) {
		this.namespaces = namespaces;
	}

	public void addJavaScriptGlobal(String content) {
		JavaScriptGlobal javascriptDef = new JavaScriptGlobal();
		javascriptDef.setContent(content);
		addChild(javascriptDef);
	}

	// public List getLayoutList() {
	// List result = new ArrayList();
	// for (Iterator it = this.getAllChildren(); it != null && it.hasNext();) {
	// Object next = it.next();
	// if (next instanceof LayoutDef) {
	// result.add(next);
	// }
	// }
	// return result;
	// }

	public void addChild(Object comp) {
		if (comp instanceof LayoutDef) {
			((LayoutDef) comp).setMaskatDef(this);
		}
		super.addChild(comp);
	}
}
