/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.bind;

import java.lang.reflect.Member;

import org.maru.dog.core.MarkedPoint;

class TargetMarkedPoint<T> extends MarkedPoint<T> {

    private Class<?> inputClass = null;

    public TargetMarkedPoint() {
        super();
    }

    public TargetMarkedPoint(Class<T> declaringClass, String name, Member member, Class<?> inputClass) {
        super(declaringClass, name, member);
        this.inputClass = inputClass;
    }

    public Class<?> getInputClass() {
        return inputClass;
    }

    public void setInputClass(Class<?> inputClass) {
        this.inputClass = inputClass;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TargetMarkedPoint [inputClass=" + inputClass + ",");
        sb.append("declaringClass=" + declaringClass + ",");
        sb.append("name=" + name + ",");
        sb.append("member=" + member + "]");
        return  sb.toString();
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((declaringClass == null) ? 0 : declaringClass.hashCode());
        result = prime * result + ((member == null) ? 0 : member.hashCode());
        result = prime * result + ((name == null) ? 0 : name.hashCode());
        result = prime * result+ ((inputClass == null) ? 0 : inputClass.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        TargetMarkedPoint<?> other = (TargetMarkedPoint<?>) obj;
        if (declaringClass == null) {
            if (other.declaringClass != null)
                return false;
        } else if (!declaringClass.equals(other.declaringClass)) {
            return false;
        }
        if (member == null) {
            if (other.member != null)
                return false;
        } else if (!member.equals(other.member)) {
            return false;
        }

        if (name == null) {
            if (other.name != null)
                return false;
        } else if (!name.equals(other.name)) {
            return false;
        }
        if (inputClass == null) {
            if (other.inputClass != null)
                return false;
        } else if (!inputClass.equals(other.inputClass)) {
            return false;
        }
        return true;
    }

}
