/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.bind;

import static org.maru.common.util.ConditionUtil.isNotNull;
import static org.maru.dog.bind.BinderFactory.createMemberBinder;

import java.util.Map;
import java.util.Map.Entry;

import org.maru.common.Key;
import org.maru.dog.core.Binder;
import org.maru.dog.core.Definition;
import org.maru.dog.core.MarkedPoint;

final class MapBinderProducer<T> implements BinderProducer {

    private final Definition<T> targetDefinition;
    private final Map<String, ?> inputs;
    private final MapBinderImpl<T> mapBinder;

    MapBinderProducer(Definition<T> targetDefinition, Map<String, ?> inputs, MapBinderImpl<T> mapBinder) {
        this.targetDefinition = targetDefinition;
        this.inputs = inputs;
        this.mapBinder = mapBinder;
    }
    public Binder getBinder() {
        return mapBinder;
    }

    public void validateAndComposeBinder() {

        for (Entry<Key<?>, MarkedPoint<T>> entry : ((BindingDefinition<T>)targetDefinition).getMarkedPoints().entrySet()) {
            Key<?> targetBoundKey = entry.getKey();
            TargetMarkedPoint<T> targetMarkedPoint = (TargetMarkedPoint<T>)entry.getValue();

            BindingContext context = createMapBindingContext(targetMarkedPoint, targetBoundKey, inputs);
            if (isNotNull(context)) {
                MemberBinder memberBinder = createMemberBinder(context, new MapBindingFactoryImpl());
                mapBinder.addMemberBinder(memberBinder);
            }
        }

    }

    private static <T> BindingContext createMapBindingContext(TargetMarkedPoint<T> targetMarkedPoint, Key<?> targetBoundKey, Map<String, ?> inputs) {
        MapBindingContextImpl  context = null;

        for (Entry<String, ?> entry : inputs.entrySet()) {
            if (targetMarkedPoint.getName().equals(entry.getKey())) {
                context = new MapBindingContextImpl(targetMarkedPoint, entry.getValue());
                break;
            }
        }
        return context;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MapBinderProducer [targetDefinition=" + targetDefinition + ",");
        sb.append("inputs=" + inputs + ",");
        sb.append("mapBinder=" + mapBinder + "]");
        return  sb.toString();
    }

}
