/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.bind;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.maru.common.Key;
import org.maru.dog.core.BinderImpl;

final class MapBinderImpl<T> extends BinderImpl<T> implements MapBinder<T> {

    private final List<MemberBinder> binders = new ArrayList<MemberBinder>();

    MapBinderImpl(Key<?> key, Class<T> type) {
        super(key, type);
    }

    static class InternalCallableMapBinderImpl<T> implements InternalCallableBinder {
        final T target;
        final Map<String, ?> input;
        final MapBinderImpl<T> mapBinder;

        InternalCallableMapBinderImpl(MapBinderImpl<T> mapBinder, T target, Map<String, ?> input) {
            this.target = target;
            this.input = input;
            this.mapBinder = mapBinder;
        }

        public T callableBind() {
            return mapBinder.bind(target, input);
        }

    }

    public InternalCallableBinder getCallableBinder(T target,
            Map<String, ?> input) {
        return new InternalCallableMapBinderImpl<T>(this, target, input);
    }

    public void addMemberBinder(MemberBinder memberBinder) {
        binders.add(memberBinder);
    }

    T bind(T target, Map<String, ?> input) {
        for (Entry<String, ?> entry : input.entrySet()) {
            for (MemberBinder memberBinder : binders) {
                memberBinder.bind(target, entry.getValue());
            }
        }
        return target;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MapBinderImpl [binders=" + binders + ",");
        sb.append("type=" + type + ",");
        sb.append("key=" + key + "]");
        return  sb.toString();
    }
}
