/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.bind;

import java.util.Map;

import org.maru.common.KeyGen;

public final class MapBinderBuilder<T> extends AbstractMapBinderBuilder<T> {

    @SuppressWarnings("unchecked")
    public MapBinderBuilder(T target, Map<String, ?> inputs) {
        super(new MapBinderImpl<T>(KeyGen.getKey(target.getClass()), (Class<T>) target.getClass()),
                target, inputs);
    }

    public AbstractTargetDefinitionBuilder<T> getTargetDefinitionBuilder(Class<?> type) {
        return new TargetMarkedDefinitionBuilder(type);
    }

    public AbstractInputDefinitionBuilder<?> getInputDefinitionBuilder(Class<?> type) {
        return null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MapBinderBuilder [targetBuilder=" + targetBuilder + ",");
        sb.append("inputs=" + inputs + ",");
        sb.append("mapBinder=" + mapBinder + "]");
        return  sb.toString();
    }

}
