/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.bind;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;

import org.maru.common.KeyGen;
import org.maru.dog.core.Definition;

final class InputActualFieldNameDefinitionBuilder<T> extends  AbstractInputDefinitionBuilder<T> {

    InputActualFieldNameDefinitionBuilder(Class<T> type) {
        super(type, new BindingDefinitionImpl<T>(type));
    }

    @Override
    protected InputMarkedPoint<T> getInputMarkedPoint(Member member, Class<T> target) {
        InputMarkedPoint<T> inputMarkedPoint = null;
        if (member instanceof Field) {
            Field f = (Field) member;

            String actualFieldName = f.getName();

            // check if converter annotation is defined.
            Annotation converterAnnotation = checkAndGetConverterClassAnnotation(f);
            ConverterDef converterDef = new ConverterDef();
            if (converterAnnotation != null) {
                converterDef = getConverterClassInformation(converterAnnotation, f.getGenericType());
                converterDef.verifyConverter();
            }

            // create marked point
            inputMarkedPoint = createInputMarkedPointInstance(target, actualFieldName, f, converterDef);

        }
        return inputMarkedPoint;
    }

    @Override
    protected boolean isStoredDefinition() {
        return BindingDefinitionCache.containsFieldNameInputDefiniton(KeyGen.getKey(target));
    }

    @SuppressWarnings("unchecked")
    @Override
    protected Definition<T> applyDefinition() {
        return (Definition<T>) BindingDefinitionCache.applyFieldNameInputDefinition(KeyGen.getKey(target), definition);
    }

    @SuppressWarnings("unchecked")
    @Override
    protected Definition<T> retrieveDefinition() {
        return (Definition<T>) BindingDefinitionCache.getFieldNameInputDefinition(KeyGen.getKey(target));
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("InputActualFieldNameDefinitionBuilder [target=" + target + ",");
        sb.append("definition=" + definition + "]");
        return  sb.toString();
    }
}
