/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.bind;

import java.lang.reflect.Field;
import java.lang.reflect.Member;

import org.maru.common.reflection.Fields;

/**
 * This class binds the binding data on the input instance to the target instance's field.
 */
public class FieldBinder<T, K> implements MemberBinder {

    private final BindingContext context;

    private final BindingFactory factory;

    public FieldBinder(BindingContext bindingContext, BindingFactory factory) {
        this.context = bindingContext;
        this.factory = factory;
    }

    public <T, K>void bind(T target, K input) {
        Object value = factory.get(context, input);
        Member member = context.getMarkedPoint().getMember();

        Fields.set((Field)member, target, value);

    }

    public BindingContext getBindingContext() {
        return this.context;
    }
}
