/*
 * Decompiled with CFR 0.152.
 */
package org.maru.dog.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.maru.common.Key;
import org.maru.common.KeyGen;
import org.maru.common.Reaper;
import org.maru.common.type.PrimitiveWrapperTypes;
import org.maru.common.util.ConditionUtil;
import org.maru.dog.Config;
import org.maru.dog.Director;
import org.maru.dog.bind.ActualFieldNameBinderBuilder;
import org.maru.dog.bind.ActualFieldNameMapBinderBuilder;
import org.maru.dog.bind.InstanceBinderBuilder;
import org.maru.dog.bind.InternalCallableBinder;
import org.maru.dog.bind.MapBinderBuilder;
import org.maru.dog.core.ClassChecker;
import org.maru.dog.core.Configuration;
import org.maru.dog.core.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DirectorImpl
implements Director {
    private static final ThreadLocal<Map<Key<?>, List<Configuration>>> LOCAL_CONFIGURATIONS = new ThreadLocal<Map<Key<?>, List<Configuration>>>(){

        @Override
        protected synchronized Map<Key<?>, List<Configuration>> initialValue() {
            return new HashMap();
        }
    };
    private static final ThreadLocal<Map<Key<?>, List<Configuration>>> LOCAL_CONFIGURATIONS_FOR_FIELD_NAME_BINDINGS = new ThreadLocal<Map<Key<?>, List<Configuration>>>(){

        @Override
        protected synchronized Map<Key<?>, List<Configuration>> initialValue() {
            return new HashMap();
        }
    };

    public DirectorImpl(Config ... configs) {
        LOCAL_CONFIGURATIONS.remove();
        LOCAL_CONFIGURATIONS_FOR_FIELD_NAME_BINDINGS.remove();
        if (ConditionUtil.isNotNull((Object)configs) && configs.length > 0) {
            this.initialize(configs);
        }
    }

    private void initialize(Config ... configs) {
        Map<Key<?>, List<Configuration>> localConfigurations = LOCAL_CONFIGURATIONS.get();
        Map<Key<?>, List<Configuration>> localConfigForFieldNameBindings = LOCAL_CONFIGURATIONS_FOR_FIELD_NAME_BINDINGS.get();
        DirectorImpl.setupConfig(localConfigurations, localConfigForFieldNameBindings, Occasion.INITIALIZING, configs);
        LOCAL_CONFIGURATIONS.set(localConfigurations);
        LOCAL_CONFIGURATIONS_FOR_FIELD_NAME_BINDINGS.set(localConfigForFieldNameBindings);
        Reaper.execute();
    }

    private static void setupConfig(Map<Key<?>, List<Configuration>> localConfigurations, Map<Key<?>, List<Configuration>> localConfigForFieldNameBindings, Occasion occasion, Config ... configs) {
        for (Config config : configs) {
            config.make();
            Map<Key<?>, List<Configuration>> configurationsMap = config.getBindingDeclarator().getConfigurationMap();
            DirectorImpl.registerConfiguration(localConfigurations, configurationsMap, occasion);
            Map<Key<?>, List<Configuration>> configurationsForFieldNameMap = config.getBindingDeclarator().getConfigurationsForFieldNameMap();
            DirectorImpl.registerConfiguration(localConfigForFieldNameBindings, configurationsForFieldNameMap, occasion);
        }
    }

    private static void registerConfiguration(Map<Key<?>, List<Configuration>> localConfigurations, Map<Key<?>, List<Configuration>> definedConfigurations, Occasion occasion) {
        block4: for (Map.Entry<Key<?>, List<Configuration>> entry : definedConfigurations.entrySet()) {
            Key<?> defKey = entry.getKey();
            List<Configuration> configurations = entry.getValue();
            if (configurations.size() <= 0) continue;
            switch (occasion) {
                case INITIALIZING: {
                    if (!localConfigurations.containsKey(defKey)) {
                        localConfigurations.put(defKey, configurations);
                        continue block4;
                    }
                    throw new IllegalArgumentException("The definition related to " + defKey.toString() + " has already existed.");
                }
                case REPLACING: {
                    localConfigurations.put(defKey, configurations);
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unexpected occasion");
        }
    }

    @Override
    public <T, K> Director bind(T target, K ... inputs) {
        if (!PrimitiveWrapperTypes.isPrimitiveOrWrapperType(target.getClass())) {
            DirectorImpl.validateTargetAndInputs(target, inputs);
            InternalCallableBinder callableBinder = this.getBinder(target, inputs);
            callableBinder.callableBind();
        }
        return this;
    }

    @Override
    public <T> Director bind(T target, Map<String, ?> inputs) {
        if (!PrimitiveWrapperTypes.isPrimitiveOrWrapperType(target.getClass())) {
            DirectorImpl.validateTargetAndInputs(target, inputs);
            InternalCallableBinder callableBinder = this.getMapBinder(target, inputs);
            callableBinder.callableBind();
        }
        return this;
    }

    @Override
    public <T, K> Director bindByFieldName(T target, K ... inputs) {
        if (!PrimitiveWrapperTypes.isPrimitiveOrWrapperType(target.getClass())) {
            DirectorImpl.validateTargetAndInputs(target, inputs);
            InternalCallableBinder callableBinder = this.getActualFieldNameBinder(target, inputs);
            callableBinder.callableBind();
        }
        return this;
    }

    @Override
    public <T> Director bindByFieldName(T target, Map<String, ?> inputs) {
        if (!PrimitiveWrapperTypes.isPrimitiveOrWrapperType(target.getClass())) {
            DirectorImpl.validateTargetAndInputs(target, inputs);
            InternalCallableBinder callableBinder = this.getActualFieldNameMapBinder(target, inputs);
            callableBinder.callableBind();
        }
        return this;
    }

    @Override
    public <T, K> T getInstance(T target, K ... inputs) {
        if (!PrimitiveWrapperTypes.isPrimitiveOrWrapperType(target.getClass())) {
            DirectorImpl.validateTargetAndInputs(target, inputs);
            InternalCallableBinder callableBinder = this.getBinder(target, inputs);
            return callableBinder.callableBind();
        }
        return target;
    }

    @Override
    public <T> T getInstance(T target, Map<String, ?> inputs) {
        if (!PrimitiveWrapperTypes.isPrimitiveOrWrapperType(target.getClass())) {
            DirectorImpl.validateTargetAndInputs(target, inputs);
            InternalCallableBinder callableBinder = this.getMapBinder(target, inputs);
            return callableBinder.callableBind();
        }
        return target;
    }

    @Override
    public <T, K> T getInstanceByFieldNameBind(T target, K ... inputs) {
        if (!PrimitiveWrapperTypes.isPrimitiveOrWrapperType(target.getClass())) {
            DirectorImpl.validateTargetAndInputs(target, inputs);
            InternalCallableBinder callableBinder = this.getActualFieldNameBinder(target, inputs);
            return callableBinder.callableBind();
        }
        return target;
    }

    @Override
    public <T> T getInstanceByFieldNameBind(T target, Map<String, ?> inputs) {
        if (!PrimitiveWrapperTypes.isPrimitiveOrWrapperType(target.getClass())) {
            DirectorImpl.validateTargetAndInputs(target, inputs);
            InternalCallableBinder callableBinder = this.getActualFieldNameMapBinder(target, inputs);
            return callableBinder.callableBind();
        }
        return target;
    }

    @Override
    public <T, K> T getInstance(Class<T> target, K ... inputs) {
        if (!PrimitiveWrapperTypes.isPrimitiveOrWrapperType(target)) {
            DirectorImpl.validateTargetAndInputs(target, inputs);
            T instance = ObjectFactory.newInstance(target);
            InternalCallableBinder callableBinder = this.getBinder(instance, inputs);
            return callableBinder.callableBind();
        }
        throw new IllegalArgumentException("The target argument is primitive or wrapper type. Can not bind dependencies to " + target.getName());
    }

    @Override
    public <T> T getInstance(Class<T> target, Map<String, ?> inputs) {
        if (!PrimitiveWrapperTypes.isPrimitiveOrWrapperType(target)) {
            DirectorImpl.validateTargetAndInputs(target, inputs);
            T instance = ObjectFactory.newInstance(target);
            InternalCallableBinder callableBinder = this.getMapBinder(instance, inputs);
            return callableBinder.callableBind();
        }
        throw new IllegalArgumentException("The target argument is primitive or wrapper type. Can not bind dependencies to " + target.getName());
    }

    @Override
    public <T, K> T getInstanceByFieldNameBind(Class<T> target, K ... inputs) {
        if (!PrimitiveWrapperTypes.isPrimitiveOrWrapperType(target)) {
            DirectorImpl.validateTargetAndInputs(target, inputs);
            T instance = ObjectFactory.newInstance(target);
            InternalCallableBinder callableBinder = this.getActualFieldNameBinder(instance, inputs);
            return callableBinder.callableBind();
        }
        throw new IllegalArgumentException("The target argument is primitive or wrapper type. Can not bind dependencies to " + target.getName());
    }

    @Override
    public <T> T getInstanceByFieldNameBind(Class<T> target, Map<String, ?> inputs) {
        if (!PrimitiveWrapperTypes.isPrimitiveOrWrapperType(target)) {
            DirectorImpl.validateTargetAndInputs(target, inputs);
            T instance = ObjectFactory.newInstance(target);
            InternalCallableBinder callableBinder = this.getActualFieldNameMapBinder(instance, inputs);
            return callableBinder.callableBind();
        }
        throw new IllegalArgumentException("The target argument is primitive or wrapper type. Can not bind dependencies to " + target.getName());
    }

    @Override
    public Director removeAllConfig() {
        LOCAL_CONFIGURATIONS.remove();
        LOCAL_CONFIGURATIONS_FOR_FIELD_NAME_BINDINGS.remove();
        return this;
    }

    @Override
    public Director replaceConfig(Config ... configs) {
        Map<Key<?>, List<Configuration>> localConfigurations = LOCAL_CONFIGURATIONS.get();
        Map<Key<?>, List<Configuration>> localConfigForFieldNameBindings = LOCAL_CONFIGURATIONS_FOR_FIELD_NAME_BINDINGS.get();
        DirectorImpl.setupConfig(localConfigurations, localConfigForFieldNameBindings, Occasion.REPLACING, configs);
        LOCAL_CONFIGURATIONS.set(localConfigurations);
        LOCAL_CONFIGURATIONS_FOR_FIELD_NAME_BINDINGS.set(localConfigForFieldNameBindings);
        return this;
    }

    private <T, K> InternalCallableBinder getBinder(T target, K ... inputs) {
        List<Configuration> configurations = this.getLocalConfigurations(target);
        InstanceBinderBuilder<T, K> builder = new InstanceBinderBuilder<T, K>(configurations, target, inputs);
        builder.build();
        return builder.getInstanceBinder().getCallableBinder(target, inputs);
    }

    private <T, K> InternalCallableBinder getActualFieldNameBinder(T target, K ... inputs) {
        List<Configuration> configurations = this.getLocalConfigurationForFieldNameBindings(target);
        ActualFieldNameBinderBuilder<T, K> builder = new ActualFieldNameBinderBuilder<T, K>(configurations, target, inputs);
        builder.build();
        return builder.getInstanceBinder().getCallableBinder(target, inputs);
    }

    private <T> InternalCallableBinder getMapBinder(T target, Map<String, ?> inputs) {
        MapBinderBuilder<T> builder = new MapBinderBuilder<T>(target, inputs);
        builder.build();
        return builder.getMapBinder().getCallableBinder(target, inputs);
    }

    private <T> InternalCallableBinder getActualFieldNameMapBinder(T target, Map<String, ?> inputs) {
        ActualFieldNameMapBinderBuilder<T> builder = new ActualFieldNameMapBinderBuilder<T>(target, inputs);
        builder.build();
        return builder.getMapBinder().getCallableBinder(target, inputs);
    }

    private <T> List<Configuration> getLocalConfigurations(T target) {
        Key key = KeyGen.getKey(target.getClass());
        return LOCAL_CONFIGURATIONS.get().get(key);
    }

    private <T> List<Configuration> getLocalConfigurationForFieldNameBindings(T target) {
        Key key = KeyGen.getKey(target.getClass());
        return LOCAL_CONFIGURATIONS_FOR_FIELD_NAME_BINDINGS.get().get(key);
    }

    private static <T, K> void validateTargetAndInputs(T target, K ... inputs) {
        DirectorImpl.checkNotNull(target, inputs);
        ClassChecker.checkInstanceType(target);
        DirectorImpl.checkInputInstanceTypes(inputs);
    }

    private static <T, K> void validateTargetAndInputs(T target, Map<String, ?> inputs) {
        DirectorImpl.checkNotNull(target, inputs);
        ClassChecker.checkInstanceType(target);
    }

    private static <T, K> void validateTargetAndInputs(Class<T> target, K ... inputs) {
        DirectorImpl.checkNotNull(target, inputs);
        ClassChecker.checkClassType(target);
        DirectorImpl.checkInputInstanceTypes(inputs);
    }

    private static <T, K> void validateTargetAndInputs(Class<T> target, Map<String, ?> inputs) {
        DirectorImpl.checkNotNull(target, inputs);
        ClassChecker.checkClassType(target);
    }

    private static <T, K> void checkNotNull(T target, K ... inputs) {
        ConditionUtil.verifyNotNull(target, (String)"The target instance is null.");
        for (K input : inputs) {
            ConditionUtil.verifyNotNull(input, (String)"One of the input instances is null.");
        }
    }

    private static <T, K> void checkNotNull(T target, Map<String, ?> input) {
        ConditionUtil.verifyNotNull(target, (String)"The target instance is null.");
        ConditionUtil.verifyNotNull(input, (String)"The map type input is null.");
    }

    private static void checkInputInstanceTypes(Object ... inputs) {
        if (ConditionUtil.isNotNull((Object)inputs) && inputs.length > 0) {
            for (Object input : inputs) {
                ClassChecker.checkInstanceType(input);
            }
        } else {
            throw new IllegalArgumentException("The input objects must need at least one instance.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Occasion {
        INITIALIZING,
        REPLACING;

    }
}

