/*
 * Decompiled with CFR 0.152.
 */
package org.maru.dog.bind;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.maru.common.Key;
import org.maru.common.KeyGen;
import org.maru.common.util.ConditionUtil;
import org.maru.common.util.StringUtil;
import org.maru.dog.DefinitionException;
import org.maru.dog.annotation.Bound;
import org.maru.dog.annotation.From;
import org.maru.dog.bind.AbstractTargetDefinitionBuilder;
import org.maru.dog.bind.BindingDefinition;
import org.maru.dog.bind.BindingDefinitionCache;
import org.maru.dog.bind.BindingDefinitionImpl;
import org.maru.dog.bind.TargetMarkedPoint;
import org.maru.dog.core.Definition;
import org.maru.dog.util.MethodUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TargetMarkedDefinitionBuilder<T>
extends AbstractTargetDefinitionBuilder<T> {
    TargetMarkedDefinitionBuilder(Class<T> type) {
        super(type, new BindingDefinitionImpl<T>(type));
    }

    @Override
    public void makeMarkedPoint(Member member) {
        TargetMarkedPoint<T> markedPoint = this.getTargetMarkedPoint(member, this.target);
        if (ConditionUtil.isNotNull(markedPoint)) {
            String keyName = markedPoint.getName();
            Key key = KeyGen.getKey((Object)keyName);
            ((BindingDefinition)this.definition).putMarkedPoint(key, markedPoint);
        }
    }

    @Override
    protected TargetMarkedPoint<T> getTargetMarkedPoint(Member member, Class<T> target) {
        Method m;
        Bound bound;
        TargetMarkedPoint<T> markedPoint = null;
        if (member instanceof Field) {
            Field f = (Field)member;
            bound = f.getAnnotation(Bound.class);
            String keyName = f.getName();
            if (bound != null) {
                if (StringUtil.isNotEmpty((String)bound.name())) {
                    keyName = bound.name();
                }
            } else {
                return null;
            }
            Class<?> inputClass = null;
            From from = f.getAnnotation(From.class);
            if (from != null) {
                inputClass = from.value();
            }
            markedPoint = TargetMarkedDefinitionBuilder.createTargetMarkedPointInstance(target, keyName, f, inputClass);
        }
        if (member instanceof Method && (bound = (m = (Method)member).getAnnotation(Bound.class)) != null) {
            String methodName = m.getName();
            if (MethodUtil.isSetterMethod(methodName, m)) {
                String keyName = null;
                keyName = StringUtil.isNotEmpty((String)bound.name()) ? bound.name() : TargetMarkedDefinitionBuilder.canonicalizeMethodName(methodName);
                if (StringUtil.isEmpty((String)keyName)) {
                    throw new IllegalArgumentException("Fail to make bound identifier. It might not be set the bound name, or setter method name is illegal style");
                }
                Class<?> inputClass = null;
                From from = m.getAnnotation(From.class);
                if (from != null) {
                    inputClass = from.value();
                }
                markedPoint = TargetMarkedDefinitionBuilder.createTargetMarkedPointInstance(target, keyName, m, inputClass);
            } else {
                throw new DefinitionException(m.getName() + " method is not setter method following JavaBeans.");
            }
        }
        return markedPoint;
    }

    @Override
    protected boolean isStoredDefinition() {
        return BindingDefinitionCache.containsTargetDefinition(KeyGen.getKey((Class)this.target));
    }

    @Override
    protected Definition<T> applyDefinition() {
        return BindingDefinitionCache.applyTargetDefinition(KeyGen.getKey((Class)this.target), this.definition);
    }

    @Override
    protected Definition<T> retrieveDefinition() {
        return BindingDefinitionCache.getTargetDefinition(KeyGen.getKey((Class)this.target));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TargetMarkedDefinitionBuilder [target=" + this.target + ",");
        sb.append("definition=" + this.definition + "]");
        return sb.toString();
    }
}

