/*
 * Decompiled with CFR 0.152.
 */
package org.maru.dog.bind;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.maru.common.Key;
import org.maru.dog.bind.InternalCallableBinder;
import org.maru.dog.bind.MapBinder;
import org.maru.dog.bind.MemberBinder;
import org.maru.dog.core.BinderImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MapBinderImpl<T>
extends BinderImpl<T>
implements MapBinder<T> {
    private final List<MemberBinder> binders = new ArrayList<MemberBinder>();

    MapBinderImpl(Key<?> key, Class<T> type) {
        super(key, type);
    }

    @Override
    public InternalCallableBinder getCallableBinder(T target, Map<String, ?> input) {
        return new InternalCallableMapBinderImpl<T>(this, target, input);
    }

    @Override
    public void addMemberBinder(MemberBinder memberBinder) {
        this.binders.add(memberBinder);
    }

    T bind(T target, Map<String, ?> input) {
        for (Map.Entry<String, ?> entry : input.entrySet()) {
            for (MemberBinder memberBinder : this.binders) {
                memberBinder.bind(target, entry.getValue());
            }
        }
        return target;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MapBinderImpl [binders=" + this.binders + ",");
        sb.append("type=" + this.type + ",");
        sb.append("key=" + this.key + "]");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class InternalCallableMapBinderImpl<T>
    implements InternalCallableBinder {
        final T target;
        final Map<String, ?> input;
        final MapBinderImpl<T> mapBinder;

        InternalCallableMapBinderImpl(MapBinderImpl<T> mapBinder, T target, Map<String, ?> input) {
            this.target = target;
            this.input = input;
            this.mapBinder = mapBinder;
        }

        @Override
        public T callableBind() {
            return this.mapBinder.bind(this.target, this.input);
        }
    }
}

