/*
 * Decompiled with CFR 0.152.
 */
package org.maru.dog.bind;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.maru.common.KeyGen;
import org.maru.common.util.StringUtil;
import org.maru.dog.DefinitionException;
import org.maru.dog.annotation.Bind;
import org.maru.dog.bind.AbstractInputDefinitionBuilder;
import org.maru.dog.bind.BindingDefinitionCache;
import org.maru.dog.bind.BindingDefinitionImpl;
import org.maru.dog.bind.ConverterDef;
import org.maru.dog.bind.InputMarkedPoint;
import org.maru.dog.core.Definition;
import org.maru.dog.util.MethodUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class InputMarkedDefinitionBuilder<T>
extends AbstractInputDefinitionBuilder<T> {
    InputMarkedDefinitionBuilder(Class<T> type) {
        super(type, new BindingDefinitionImpl<T>(type));
    }

    @Override
    protected InputMarkedPoint<T> getInputMarkedPoint(Member member, Class<T> target) {
        InputMarkedPoint<T> inputMarkedPoint = null;
        if (member instanceof Field) {
            Field f = (Field)member;
            Bind bind = f.getAnnotation(Bind.class);
            String keyName = f.getName();
            if (bind != null) {
                if (StringUtil.isNotEmpty((String)bind.name())) {
                    keyName = bind.name();
                }
            } else {
                return null;
            }
            Annotation converterAnnotation = InputMarkedDefinitionBuilder.checkAndGetConverterClassAnnotation(f);
            ConverterDef converterDef = new ConverterDef();
            if (converterAnnotation != null) {
                converterDef = InputMarkedDefinitionBuilder.getConverterClassInformation(converterAnnotation, f.getGenericType());
                converterDef.verifyConverter();
            }
            inputMarkedPoint = InputMarkedDefinitionBuilder.createInputMarkedPointInstance(target, keyName, f, converterDef);
            return inputMarkedPoint;
        }
        Method m = (Method)member;
        Bind bind = m.getAnnotation(Bind.class);
        if (bind != null) {
            String methodName = m.getName();
            if (MethodUtil.isGetterMethod(methodName, m)) {
                String keyName = null;
                keyName = StringUtil.isNotEmpty((String)bind.name()) ? bind.name() : InputMarkedDefinitionBuilder.canonicalizeMethodName(methodName);
                if (StringUtil.isEmpty((String)keyName)) {
                    throw new IllegalArgumentException("Fail to make bind identifier. It might not be set the bind name, or gettter method name is illegal style");
                }
                Annotation converterAnnotation = InputMarkedDefinitionBuilder.checkAndGetConverterClassAnnotation(m);
                ConverterDef converterDef = new ConverterDef();
                if (converterAnnotation != null) {
                    converterDef = InputMarkedDefinitionBuilder.getConverterClassInformation(converterAnnotation, m.getGenericReturnType());
                    converterDef.verifyConverter();
                }
                inputMarkedPoint = InputMarkedDefinitionBuilder.createInputMarkedPointInstance(target, keyName, m, converterDef);
            } else {
                throw new DefinitionException(m.getName() + " method is not getter method following JavaBeans.");
            }
        }
        return inputMarkedPoint;
    }

    @Override
    protected boolean isStoredDefinition() {
        return BindingDefinitionCache.containsInputDefinition(KeyGen.getKey((Class)this.target));
    }

    @Override
    protected Definition<T> applyDefinition() {
        return BindingDefinitionCache.applyInputDefinition(KeyGen.getKey((Class)this.target), this.definition);
    }

    @Override
    protected Definition<T> retrieveDefinition() {
        return BindingDefinitionCache.getInputDefinition(KeyGen.getKey((Class)this.target));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("InputMarkedDefinitionBuilder [target=" + this.target + ",");
        sb.append("definition=" + this.definition + "]");
        return sb.toString();
    }
}

