/*
 * Decompiled with CFR 0.152.
 */
package org.maru.dog.bind;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.maru.common.Key;
import org.maru.common.KeyGen;
import org.maru.common.annotation.Identifier;
import org.maru.common.annotation.Value;
import org.maru.common.type.GenericClassType;
import org.maru.common.util.ConditionUtil;
import org.maru.common.util.StringUtil;
import org.maru.dog.converter.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConverterDef {
    Class<?> converterClass = null;
    Method converterMethod = null;
    Annotation converterAnnotation = null;
    Type convertedValueType = null;
    final List<Key<?>> identifierParameters = new ArrayList();

    ConverterDef() {
    }

    ConverterDef(Class<?> converterClass, Method converterMethod, Annotation converterAnnotation) {
        this.converterClass = converterClass;
        if (!converterMethod.isAccessible()) {
            converterMethod.setAccessible(true);
        }
        this.converterMethod = converterMethod;
        this.converterAnnotation = converterAnnotation;
    }

    void verifyConverter() {
        ConditionUtil.verifyNotNull(this.converterClass, (String)"The converter class is null.");
        ConditionUtil.verifyNotNull((Object)this.converterMethod, (String)"The converter method is null.");
        ConditionUtil.verifyNotNull((Object)this.converterAnnotation, (String)"The converter annotation is null.");
        if (this.converterAnnotation instanceof Converter) {
            this.convertedValueType = this.converterMethod.getGenericParameterTypes()[0];
        } else {
            Annotation[][] parameterAnnotations = this.converterMethod.getParameterAnnotations();
            for (int i = 0; i < parameterAnnotations.length; ++i) {
                for (int j = 0; j < parameterAnnotations[i].length; ++j) {
                    if (parameterAnnotations[i][j] instanceof Value) {
                        Key valueKey = KeyGen.getKey(parameterAnnotations[i][j].annotationType());
                        if (this.identifierParameters.contains(valueKey)) {
                            throw new IllegalArgumentException(valueKey + "is not unique.");
                        }
                        this.identifierParameters.add(valueKey);
                        this.convertedValueType = this.converterMethod.getGenericParameterTypes()[i];
                    }
                    if (!(parameterAnnotations[i][j] instanceof Identifier)) continue;
                    Identifier identifier = (Identifier)parameterAnnotations[i][j];
                    String identifierName = identifier.value();
                    if (StringUtil.isNotEmpty((String)identifierName)) {
                        Key identifierNameKey = KeyGen.getKey((Object)identifierName);
                        if (this.identifierParameters.contains(identifierNameKey)) {
                            throw new IllegalArgumentException(identifierNameKey + "is not unique.");
                        }
                        this.identifierParameters.add(identifierNameKey);
                        continue;
                    }
                    throw new IllegalArgumentException("The name of Identification is not set to the parameter.");
                }
            }
            if (this.convertedValueType == null) {
                throw new IllegalArgumentException("There is no @Value annotation on the parameter of the covnerter method.");
            }
            if (this.converterAnnotation.annotationType().getDeclaredMethods().length != this.identifierParameters.size() - 1) {
                throw new IllegalArgumentException("Attributes of converter annotation and parameter's attributes on a converter method must be same length.");
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConverterDef [attributeParameters=" + this.identifierParameters);
        sb.append(", convertedValueType=" + this.convertedValueType);
        sb.append(", converterAnnotation=" + this.converterAnnotation);
        sb.append(", converterClass=" + this.converterClass);
        sb.append(", converterMethod=" + this.converterMethod + "]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.convertedValueType == null ? 0 : this.convertedValueType.hashCode());
        result = 31 * result + (this.converterAnnotation == null ? 0 : ((Object)this.converterAnnotation).hashCode());
        result = 31 * result + (this.converterClass == null ? 0 : this.converterClass.hashCode());
        result = 31 * result + (this.converterMethod == null ? 0 : this.converterMethod.hashCode());
        result = 31 * result + (this.identifierParameters == null ? 0 : ((Object)this.identifierParameters).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConverterDef other = (ConverterDef)obj;
        if (this.convertedValueType == null ? other.convertedValueType != null : !GenericClassType.getGenericClassType((Type)this.convertedValueType).equals((Object)GenericClassType.getGenericClassType((Type)other.convertedValueType))) {
            return false;
        }
        if (this.converterAnnotation == null ? other.converterAnnotation != null : !((Object)this.converterAnnotation).equals(other.converterAnnotation)) {
            return false;
        }
        if (this.converterClass == null ? other.converterClass != null : !this.converterClass.equals(other.converterClass)) {
            return false;
        }
        if (this.converterMethod == null ? other.converterMethod != null : !this.converterMethod.equals(other.converterMethod)) {
            return false;
        }
        return !(this.identifierParameters == null ? other.identifierParameters != null : !Arrays.equals(this.identifierParameters.toArray(), other.identifierParameters.toArray()));
    }
}

