/*
 * Decompiled with CFR 0.152.
 */
package org.maru.dog.bind;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.maru.common.Key;
import org.maru.common.MapFactory;
import org.maru.dog.core.Definition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BindingDefinitionCache {
    private static final ConcurrentMap<Key<?>, Definition<?>> CACHED_TARGET_DEFINITIONS = MapFactory.createConcurrentSoftMap();
    private static final ConcurrentMap<Key<?>, Definition<?>> CACHED_INPUT_DEFINITIONS = MapFactory.createConcurrentSoftMap();
    private static final ConcurrentMap<Key<?>, Definition<?>> CACHED_FIELD_NAME_TARGET_DEFINITIONS = MapFactory.createConcurrentSoftMap();
    private static final ConcurrentMap<Key<?>, Definition<?>> CACHED_FIELD_NAME_INPUT_DEFINITIONS = MapFactory.createConcurrentSoftMap();

    private BindingDefinitionCache() {
    }

    public static Definition<?> getInputDefinition(Key<?> key) {
        return (Definition)CACHED_INPUT_DEFINITIONS.get(key);
    }

    public static Definition<?> getTargetDefinition(Key<?> key) {
        return (Definition)CACHED_TARGET_DEFINITIONS.get(key);
    }

    public static Definition<?> getFieldNameInputDefinition(Key<?> key) {
        return (Definition)CACHED_FIELD_NAME_INPUT_DEFINITIONS.get(key);
    }

    public static Definition<?> getFieldNameTargetDefinition(Key<?> key) {
        return (Definition)CACHED_FIELD_NAME_TARGET_DEFINITIONS.get(key);
    }

    public static boolean containsTargetDefinition(Key<?> key) {
        return CACHED_TARGET_DEFINITIONS.containsKey(key);
    }

    public static boolean containsInputDefinition(Key<?> key) {
        return CACHED_INPUT_DEFINITIONS.containsKey(key);
    }

    public static boolean containsFieldNameTargetDefinition(Key<?> key) {
        return CACHED_FIELD_NAME_TARGET_DEFINITIONS.containsKey(key);
    }

    public static boolean containsFieldNameInputDefiniton(Key<?> key) {
        return CACHED_FIELD_NAME_INPUT_DEFINITIONS.containsKey(key);
    }

    public static Definition<?> applyTargetDefinition(Key<?> key, Definition<?> definition) {
        return CACHED_TARGET_DEFINITIONS.putIfAbsent(key, definition);
    }

    public static Definition<?> applyInputDefinition(Key<?> key, Definition<?> definition) {
        return CACHED_INPUT_DEFINITIONS.putIfAbsent(key, definition);
    }

    public static Definition<?> applyFieldNameTargetDefinition(Key<?> key, Definition<?> definition) {
        return CACHED_FIELD_NAME_TARGET_DEFINITIONS.putIfAbsent(key, definition);
    }

    public static Definition<?> applyFieldNameInputDefinition(Key<?> key, Definition<?> definition) {
        return CACHED_FIELD_NAME_INPUT_DEFINITIONS.putIfAbsent(key, definition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAll() {
        ReentrantLock lock = new ReentrantLock();
        lock.lock();
        try {
            if (!CACHED_TARGET_DEFINITIONS.isEmpty()) {
                CACHED_TARGET_DEFINITIONS.clear();
            }
            if (!CACHED_INPUT_DEFINITIONS.isEmpty()) {
                CACHED_INPUT_DEFINITIONS.clear();
            }
            if (!CACHED_FIELD_NAME_TARGET_DEFINITIONS.isEmpty()) {
                CACHED_FIELD_NAME_TARGET_DEFINITIONS.clear();
            }
            if (!CACHED_FIELD_NAME_INPUT_DEFINITIONS.isEmpty()) {
                CACHED_FIELD_NAME_INPUT_DEFINITIONS.clear();
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static Definition<?> removeTargetDefinition(Key<?> key) {
        return (Definition)CACHED_TARGET_DEFINITIONS.remove(key);
    }

    public static Definition<?> removeInputDefinition(Key<?> key) {
        return (Definition)CACHED_INPUT_DEFINITIONS.remove(key);
    }

    public static Definition<?> removeFieldNameTargetDefinition(Key<?> key) {
        return (Definition)CACHED_FIELD_NAME_TARGET_DEFINITIONS.remove(key);
    }

    public static Definition<?> removeFieldNameInputDefinition(Key<?> key) {
        return (Definition)CACHED_FIELD_NAME_INPUT_DEFINITIONS.remove(key);
    }
}

