/*
 * Decompiled with CFR 0.152.
 */
package org.maru.dog.bind;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.maru.common.Key;
import org.maru.common.KeyGen;
import org.maru.common.annotation.Execute;
import org.maru.common.reflection.Clazz;
import org.maru.common.type.GenericClassType;
import org.maru.common.util.ConditionUtil;
import org.maru.common.util.StringUtil;
import org.maru.dog.DefinitionException;
import org.maru.dog.bind.BindingDefinition;
import org.maru.dog.bind.ConverterDef;
import org.maru.dog.bind.InputMarkedPoint;
import org.maru.dog.converter.Converter;
import org.maru.dog.converter.ConverterIdentifier;
import org.maru.dog.core.AbstractDefinitionBuilder;
import org.maru.dog.core.Definition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractInputDefinitionBuilder<T>
extends AbstractDefinitionBuilder<T> {
    public AbstractInputDefinitionBuilder(Class<T> target, Definition<T> definition) {
        super(target, definition);
    }

    @Override
    public void makeMarkedPoint(Member member) {
        InputMarkedPoint<T> inputMarkedPoint = this.getInputMarkedPoint(member, this.target);
        if (ConditionUtil.isNotNull(inputMarkedPoint)) {
            String keyName = inputMarkedPoint.getName();
            Key key = KeyGen.getKey((Object)keyName);
            ((BindingDefinition)this.definition).putMarkedPoint(key, inputMarkedPoint);
        }
    }

    protected abstract InputMarkedPoint<T> getInputMarkedPoint(Member var1, Class<T> var2);

    protected static <T> InputMarkedPoint<T> createInputMarkedPointInstance(Class<T> target, String name, Member member, ConverterDef converterDef) {
        return new InputMarkedPoint<T>(target, name, member, converterDef);
    }

    protected static ConverterDef getConverterClassInformation(Annotation converterAnnotation, Type type) {
        ConverterDef converterDef = new ConverterDef();
        if (converterAnnotation instanceof Converter) {
            Converter converter = (Converter)converterAnnotation;
            if (converter != null) {
                converterDef.converterClass = converter.converterClass();
                String executeIdentifier = converter.execute();
                converterDef.converterMethod = AbstractInputDefinitionBuilder.checkAndGetConverterClassMethod(executeIdentifier, converterDef.converterClass, GenericClassType.getClassFromType((Type)type));
            }
        } else {
            ConverterIdentifier converterIdentifier = converterAnnotation.annotationType().getAnnotation(ConverterIdentifier.class);
            converterDef.converterClass = converterIdentifier.value();
            converterDef.converterMethod = AbstractInputDefinitionBuilder.checkAndGetConverterMethod(converterAnnotation, converterDef.converterClass, type);
        }
        converterDef.converterAnnotation = converterAnnotation;
        return converterDef;
    }

    protected static Method checkAndGetConverterClassMethod(String executeIdentifier, Class<?> converterClass, Class<?> type) {
        Method method = null;
        if (StringUtil.isNotEmpty((String)executeIdentifier)) {
            int duplicatingCount = 0;
            for (Method m : converterClass.getDeclaredMethods()) {
                Execute execute = m.getAnnotation(Execute.class);
                if (!ConditionUtil.isNotNull((Object)execute) || !execute.value().equals(executeIdentifier) && !m.getName().equals(executeIdentifier)) continue;
                method = m;
                ++duplicatingCount;
            }
            if (duplicatingCount > 1) {
                throw new DefinitionException("[" + executeIdentifier + "] The name of executing identifier is duplicate.");
            }
        } else {
            method = Clazz.getDeclaredMethod(converterClass, (String)"execute", (Class[])new Class[]{type});
        }
        if (AbstractInputDefinitionBuilder.checkSimpleConverterMethodDefinition(method)) {
            return method;
        }
        throw new DefinitionException("The Definition of simple convert class [" + converterClass.getName() + "] is invalid.");
    }

    protected static boolean checkSimpleConverterMethodDefinition(Method method) {
        return ConditionUtil.isNotNull((Object)method) && !method.getGenericReturnType().equals(Void.TYPE) && method.getGenericParameterTypes().length == 1;
    }

    protected static Annotation checkAndGetConverterClassAnnotation(Member member) {
        int number = 0;
        Annotation converterAnnotation = null;
        if (member instanceof Field) {
            Field field = (Field)member;
            for (Annotation annotation : field.getAnnotations()) {
                if (!AbstractInputDefinitionBuilder.isConverterAnnotation(annotation)) continue;
                converterAnnotation = annotation;
                ++number;
            }
        } else if (member instanceof Method) {
            Method method = (Method)member;
            for (Annotation annotation : method.getAnnotations()) {
                if (!AbstractInputDefinitionBuilder.isConverterAnnotation(annotation)) continue;
                converterAnnotation = annotation;
                ++number;
            }
        }
        if (number > 1) {
            throw new IllegalArgumentException("Two converter annotations are specified on one attribute");
        }
        return converterAnnotation;
    }

    protected static boolean isConverterAnnotation(Annotation annotation) {
        if (annotation instanceof Converter) {
            return true;
        }
        ConverterIdentifier converterIdentifier = annotation.annotationType().getAnnotation(ConverterIdentifier.class);
        return ConditionUtil.isNotNull((Object)converterIdentifier);
    }

    protected static Method checkAndGetConverterMethod(Annotation converterAnnotation, Class<?> converterClass, Type type) {
        int count = 0;
        Method converterMethod = null;
        for (Method method : converterClass.getDeclaredMethods()) {
            ConverterIdentifier converterIdentifier = method.getAnnotation(ConverterIdentifier.class);
            if (converterIdentifier == null || !converterIdentifier.value().equals(converterAnnotation.annotationType())) continue;
            converterMethod = method;
            ++count;
        }
        if (count > 1) {
            throw new IllegalArgumentException(converterAnnotation.annotationType().getName() + " is not unique on the " + converterClass.getName());
        }
        if (ConditionUtil.isNotNull(converterMethod) && !converterMethod.getGenericReturnType().equals(Void.TYPE) && converterMethod.getGenericParameterTypes().length >= 1) {
            return converterMethod;
        }
        throw new DefinitionException("The Definition of the extended convert class [" + converterClass.getName() + "] is invalid.");
    }
}

