/*
 * Decompiled with CFR 0.152.
 */
package org.maru.common.type;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveWrapperTypes {
    private static final ConcurrentMap<Type, Type> PRIMITIVE_WRAPPER_TYPES = new ConcurrentHashMap<Type, Type>();

    public static boolean isPrimitiveType(Type type) {
        return PRIMITIVE_WRAPPER_TYPES.containsKey(type);
    }

    public static boolean isWrapperType(Type type) {
        return PRIMITIVE_WRAPPER_TYPES.containsValue(type);
    }

    public static boolean isPrimitiveOrWrapperType(Type type) {
        return PrimitiveWrapperTypes.isPrimitiveType(type) || PrimitiveWrapperTypes.isWrapperType(type);
    }

    public static Type getWrapperType(Type type) {
        return (Type)PRIMITIVE_WRAPPER_TYPES.get(type);
    }

    public static Type getPrimitiveType(Class<?> type) {
        for (Map.Entry entry : PRIMITIVE_WRAPPER_TYPES.entrySet()) {
            if (!((Type)entry.getValue()).equals(type)) continue;
            return (Type)entry.getKey();
        }
        return null;
    }

    static {
        PRIMITIVE_WRAPPER_TYPES.put(Byte.TYPE, (Type)((Object)Byte.class));
        PRIMITIVE_WRAPPER_TYPES.put(Short.TYPE, (Type)((Object)Short.class));
        PRIMITIVE_WRAPPER_TYPES.put(Integer.TYPE, (Type)((Object)Integer.class));
        PRIMITIVE_WRAPPER_TYPES.put(Long.TYPE, (Type)((Object)Long.class));
        PRIMITIVE_WRAPPER_TYPES.put(Float.TYPE, (Type)((Object)Float.class));
        PRIMITIVE_WRAPPER_TYPES.put(Double.TYPE, (Type)((Object)Double.class));
        PRIMITIVE_WRAPPER_TYPES.put(Character.TYPE, (Type)((Object)Character.class));
        PRIMITIVE_WRAPPER_TYPES.put((Type)((Object)CharSequence.class), (Type)((Object)String.class));
        PRIMITIVE_WRAPPER_TYPES.put(Void.TYPE, (Type)((Object)Void.class));
        PRIMITIVE_WRAPPER_TYPES.put(Boolean.TYPE, (Type)((Object)Boolean.class));
    }
}

