/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.m4hv.extensions.validator;

import static org.maru.m4hv.extensions.util.Condition.checkIncludedCorrectRange;
import static org.maru.m4hv.extensions.util.Condition.isIncludedInRange;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import org.maru.m4hv.extensions.constraints.Minutes;

/**
 * Minutes validator for Number type.<br>
 *
 * Now the support types are byte, short int.
 *
 *
 */
public class MinutesValidatorForNumber extends AbstractHmsValidatorForNumber implements ConstraintValidator<Minutes, Number> {

    private static final int MIN_MINUTES = 0;

    private static final int MAX_MINUTES = 59;

    public void initialize(Minutes minutes) {
        start = checkIncludedCorrectRange(minutes.from(), MIN_MINUTES, MAX_MINUTES);
        end = checkIncludedCorrectRange(minutes.until(), MIN_MINUTES, MAX_MINUTES);
        checkProperTimeRange("minutes", start, end);

    }

    /**
     * Validates if the given object is actual minutes and included in arbitarary defined ranges
     */
    public boolean isValid(Number object, ConstraintValidatorContext constraintContext) {
        if (object == null) {
            return true;
        }

        Integer value = getValueAsActualType(object);

        return isIncludedInRange(value, start, end);
    }

}
