/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.m4hv.extensions.validator;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.maru.m4hv.extensions.constraints.NumberString;

public class NumberStringValidator implements ConstraintValidator<NumberString, String> {

    private int min;
    private int max;

    public void initialize(NumberString numberString) {
        this.min = numberString.min();
        this.max = numberString.max();

    }

    public boolean isValid(String object, ConstraintValidatorContext constraintContext) {
        if (object == null) {
            return true;
        }

        if (object.length() >= min && object.length() <= max) {
            for (int i = 0; i < object.length(); i++) {
                int ch = object.charAt(i);
                if (ch < Characters.NUMBER_ZERO_LETTER || ch > Characters.NUMBER_NINE_LETTER) {
                    return false;
                }
            }
            return true;
        }

        return false;
    }

}
