/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.m4hv.extensions.validator;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import org.maru.m4hv.extensions.constraints.Katakana;
import org.maru.m4hv.extensions.constraints.SpaceType;

public class KatakanaValidator implements ConstraintValidator<Katakana, String> {

    private boolean enablePunctuation;

    private boolean enableIterationMarks;

    private boolean enableKatakanaDigraph;

    private boolean enableSpace;

    private boolean enablePhoneticExtensions;

    private SpaceType spaceType;

    public void initialize(Katakana katakana) {
        this.enablePunctuation = katakana.enablePunctuation();
        this.enableIterationMarks = katakana.enableIterationMarks();
        this.enableKatakanaDigraph = katakana.enableKatakanaDigraph();
        this.enableSpace = katakana.enableSpace();
        this.enablePhoneticExtensions = katakana.enablePhoneticExtensions();
        this.spaceType = katakana.spaceType();

    }

    public boolean isValid(String object, ConstraintValidatorContext constraintConetxt) {
        if (object == null) {
            return true;
        }

        for (int i = 0; i < object.codePointCount(0, object.length()); i++) {
            if (object.codePointAt(i) >= Characters.START_KATAKANA_LETTER &&
                    object.codePointAt(i) <= Characters.END_KATAKANA_LETTER) {
                continue;
            }
            if (enablePunctuation == true) {
                if (object.codePointAt(i) == Characters.KATAKANA_HIRAGANA_DOUBLE_HYPHEN) {
                    continue;
                }
            }
            if (enableIterationMarks == true) {
                if (object.codePointAt(i) == Characters.KATAKANA_ITERATION_MARK ||
                        object.codePointAt(i) == Characters.KATAKANA_VOICED_ITERATION_MARK) {
                    continue;
                }
            }

            if (enableKatakanaDigraph == true) {
                if (object.codePointAt(i) == Characters.KATAKANA_DIGRAPH_KOTO) {
                    continue;
                }
            }
            if (enablePhoneticExtensions == true) {
                if (object.codePointAt(i) >= Characters.KATAKANA_PHONETIC_EXTENSIONS_START
                        && object.codePointAt(i) <= Characters.KATAKANA_PHONETIC_EXTENSIONS_END) {
                    continue;
                }
            }
            if (enableSpace == true) {
                if (spaceType.equals(SpaceType.BOTH)) {
                    if (object.codePointAt(i) == Characters.FULLWIDTH_SPACE ||
                            object.codePointAt(i) == Characters.HALFWIDTH_SPACE) {
                        continue;
                    }
                } else if (spaceType.equals(SpaceType.FULLWIDTH_SPACE)) {
                    if (object.codePointAt(i) == Characters.FULLWIDTH_SPACE) {
                        continue;
                    }
                } else {
                    // The space type is hulf width space.
                    if (object.codePointAt(i) == Characters.HALFWIDTH_SPACE) {
                        continue;
                    }
                }
            }
            return false;
        }
        return true;
    }

}
