/*
 * Decompiled with CFR 0.152.
 */
package org.maru.m4hv.extensions.validator;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.maru.m4hv.extensions.constraints.Seconds;
import org.maru.m4hv.extensions.util.Condition;
import org.maru.m4hv.extensions.validator.AbstractHmsValidatorForString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecondsValidatorForString
extends AbstractHmsValidatorForString
implements ConstraintValidator<Seconds, String> {
    private static final int MIN_SECONDS = 0;
    private static final int MAX_SECONDS = 59;

    public void initialize(Seconds seconds) {
        this.start = Condition.checkIncludedCorrectRange(seconds.from(), 0, 59);
        this.end = Condition.checkIncludedCorrectRange(seconds.until(), 0, 59);
        this.checkProperTimeRange("seconds", this.start, this.end);
    }

    public boolean isValid(String object, ConstraintValidatorContext constraintContext) {
        if (object == null) {
            return true;
        }
        Integer value = this.getValueAsActualType(object);
        return Condition.isIncludedInRange(value, this.start, this.end);
    }
}

