/*
 * Decompiled with CFR 0.152.
 */
package org.maru.m4hv.extensions.validator;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.maru.m4hv.extensions.constraints.Minutes;
import org.maru.m4hv.extensions.util.Condition;
import org.maru.m4hv.extensions.validator.AbstractHmsValidatorForNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinutesValidatorForNumber
extends AbstractHmsValidatorForNumber
implements ConstraintValidator<Minutes, Number> {
    private static final int MIN_MINUTES = 0;
    private static final int MAX_MINUTES = 59;

    public void initialize(Minutes minutes) {
        this.start = Condition.checkIncludedCorrectRange(minutes.from(), 0, 59);
        this.end = Condition.checkIncludedCorrectRange(minutes.until(), 0, 59);
        this.checkProperTimeRange("minutes", this.start, this.end);
    }

    public boolean isValid(Number object, ConstraintValidatorContext constraintContext) {
        if (object == null) {
            return true;
        }
        Integer value = this.getValueAsActualType(object);
        return Condition.isIncludedInRange(value, this.start, this.end);
    }
}

