/*
 * Decompiled with CFR 0.152.
 */
package org.maru.m4hv.extensions.validator;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.maru.m4hv.extensions.constraints.Hours;
import org.maru.m4hv.extensions.util.Condition;
import org.maru.m4hv.extensions.validator.AbstractHmsValidatorForNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HoursValidatorForNumber
extends AbstractHmsValidatorForNumber
implements ConstraintValidator<Hours, Number> {
    private static final int MIN_HOURS = 0;
    private static final int MAX_HOURS = 23;

    public void initialize(Hours hours) {
        this.start = Condition.checkIncludedCorrectRange(hours.from(), 0, 23);
        this.end = Condition.checkIncludedCorrectRange(hours.until(), 0, 23);
        this.checkProperTimeRange("hours", this.start, this.end);
    }

    public boolean isValid(Number object, ConstraintValidatorContext constraintContext) {
        if (object == null) {
            return true;
        }
        Integer value = this.getValueAsActualType(object);
        return Condition.isIncludedInRange(value, this.start, this.end);
    }
}

