/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.m4hv.extensions.validator;

import static org.maru.m4hv.extensions.util.Condition.checkIncludedCorrectRange;
import static org.maru.m4hv.extensions.util.Condition.isIncludedInRange;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import org.maru.m4hv.extensions.constraints.Hour;

/**
 * Hour validator for String type.
 *
 */
public class HourValidatorForString extends AbstractHmsValidatorForString implements ConstraintValidator<Hour, String> {

    private int startHour;

    private int endHour;

    private static final int MIN_HOUR = 0;

    private static final int MAX_HOUR = 23;

    public void initialize(Hour hour) {
        startHour = checkIncludedCorrectRange(hour.from(), MIN_HOUR, MAX_HOUR);
        endHour = checkIncludedCorrectRange(hour.until(), MIN_HOUR, MAX_HOUR);
        checkProperTimeRange("hour", startHour, endHour);

    }

    /**
     * Validates if the given object is actual hour and included in arbitarary defined ranges
     */
    public boolean isValid(String object, ConstraintValidatorContext constraintContext) {
        if (object == null) {
            return true;
        }

        Integer value = getValueAsActualType(object);

        return isIncludedInRange(value, startHour, endHour);
    }

}
