package org.maru.m4hv.extensions.validator;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import org.maru.m4hv.extensions.constraints.HalfwidthKatakana;

public class HalfwidthKatakanaValidator implements ConstraintValidator<HalfwidthKatakana, String> {

    private boolean enableSpace;

    public void initialize(HalfwidthKatakana halfwidthKatakana) {
        this.enableSpace = halfwidthKatakana.enableSpace();

    }

    public boolean isValid(String object, ConstraintValidatorContext constraintContext) {
        if (object == null) {
            return true;
        }

        for (int i = 0; i < object.codePointCount(0, object.length()); i++) {
            if (object.codePointAt(i) >= Characters.HALFWIDTH_KATAKANA_START
                    && object.codePointAt(i) <= Characters.HALFWIDTH_KATAKANA_END) {
                continue;
            }
            if (enableSpace == true) {
                if (object.codePointAt(i) == Characters.HALFWIDTH_SPACE) {
                    continue;
                }
            }
            return false;
        }
        return true;
    }

}
