/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.m4hv.extensions.validator;

import java.text.BreakIterator;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import org.maru.m4hv.extensions.constraints.CharLength;

public class CharLengthValidator implements ConstraintValidator<CharLength, String> {

    private int min;
    private int max;

    public void initialize(CharLength charLength) {
        this.min = charLength.min();
        this.max = charLength.max();
    }

    public boolean isValid(String object, ConstraintValidatorContext constraintContext) {
        if (object == null) {
            return true;
        }

        BreakIterator breakIterator = BreakIterator.getCharacterInstance();
        breakIterator.setText(object);
        int charCount = 0;
        for (int start = breakIterator.first(), end = breakIterator.next();
                end != BreakIterator.DONE;
                start = end, end = breakIterator.next()) {
            charCount++;
        }

        if (charCount >= min && charCount <= max) {
            return true;
        } else {
            return false;
        }
    }

}
