/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.m4hv.extensions.constraints;

import static java.lang.annotation.ElementType.CONSTRUCTOR;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.ANNOTATION_TYPE;
import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import javax.validation.Constraint;
import javax.validation.Payload;

import org.maru.m4hv.extensions.validator.MinuteValidatorForString;
import org.maru.m4hv.extensions.validator.MinuteValidatorForNumber;

/**
 * Minute validator<br>
 *
 * This validator validate if given value is correct minute. Hour is represented 0 to 59.
 * By default maximum and minimum minutes are defined on attributes of {@code Minute} annotation,
 * from,until. Both attributes are actually the integer type and for the from attribute you can
 * define 0 to 59 and until so on. If you define any number out of the minute range, the runtime
 * exception is thrown.<br>
 * The support types are<br>
 * <pre>
 *     byte
 *     short
 *     int
 *     String
 * </pre>
 *
 */
@Target({METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER})
@Retention(RUNTIME)
@Constraint(validatedBy = {MinuteValidatorForString.class, MinuteValidatorForNumber.class})
@Documented
public @interface Minute {

    String message() default "{org.maru.m4hv.extensions.Minute.message}";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};

    int from() default 0;

    int until() default 59;

    @Target({METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER})
    @Retention(RUNTIME)
    @Documented
    @interface List {
        Minute[] value();
    }
}
