/*
 * Decompiled with CFR 0.152.
 */
package org.maru.m4hv.extensions.validator;

import java.util.Date;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.maru.m4hv.extensions.constraints.Time;
import org.maru.m4hv.extensions.util.DateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeValidator
implements ConstraintValidator<Time, String> {
    private Date startTime;
    private Date endTime;
    private String[] patterns;
    private static final String EXCEPTION_MESSAGE = "Unexpected time : ";

    public void initialize(Time time) {
        this.patterns = time.patterns();
        String start = time.from();
        this.startTime = DateUtil.canonicalize(start, this.patterns, EXCEPTION_MESSAGE);
        String end = time.until();
        this.endTime = DateUtil.canonicalize(end, this.patterns, EXCEPTION_MESSAGE);
    }

    public boolean isValid(String time, ConstraintValidatorContext constraintContext) {
        Date inputTime;
        if (time == null) {
            return true;
        }
        try {
            inputTime = DateUtil.canonicalize(time, this.patterns, EXCEPTION_MESSAGE);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return inputTime.compareTo(this.startTime) >= 0 && inputTime.compareTo(this.endTime) <= 0;
    }
}

