/*
 * Decompiled with CFR 0.152.
 */
package org.maru.m4hv.extensions.validator;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.maru.m4hv.extensions.constraints.Hour;
import org.maru.m4hv.extensions.util.Condition;
import org.maru.m4hv.extensions.validator.AbstractHmsValidatorForString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HourValidatorForString
extends AbstractHmsValidatorForString
implements ConstraintValidator<Hour, String> {
    private int startHour;
    private int endHour;
    private static final int MIN_HOUR = 0;
    private static final int MAX_HOUR = 23;

    public void initialize(Hour hour) {
        this.startHour = Condition.checkIncludedCorrectRange(hour.from(), 0, 23);
        this.endHour = Condition.checkIncludedCorrectRange(hour.until(), 0, 23);
        this.checkProperTimeRange("hour", this.startHour, this.endHour);
    }

    public boolean isValid(String object, ConstraintValidatorContext constraintContext) {
        if (object == null) {
            return true;
        }
        Integer value = this.getValueAsActualType(object);
        return Condition.isIncludedInRange(value, this.startHour, this.endHour);
    }
}

