/*
 * Decompiled with CFR 0.152.
 */
package org.maru.m4hv.extensions.validator;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.maru.m4hv.extensions.constraints.Second;
import org.maru.m4hv.extensions.util.Condition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecondValidatorForString
implements ConstraintValidator<Second, String> {
    private int startSecond;
    private int endSecond;
    private static final int MIN_SECOND = 0;
    private static final int MAX_SECOND = 59;

    public void initialize(Second second) {
        this.startSecond = Condition.checkIncludedCorrectRange(second.from(), 0, 59);
        this.endSecond = Condition.checkIncludedCorrectRange(second.until(), 0, 59);
        if (!Condition.isLessThan(this.startSecond, this.endSecond)) {
            throw new IllegalArgumentException("The start second [" + this.startSecond + "] must be less than the end second [" + this.startSecond + "]");
        }
    }

    public boolean isValid(String object, ConstraintValidatorContext constraintContext) {
        if (object == null) {
            return true;
        }
        Integer value = Integer.valueOf(object);
        return Condition.isIncludedInRange(value, this.startSecond, this.endSecond);
    }
}

