/*
 * Decompiled with CFR 0.152.
 */
package org.maru.m4hv.extensions.validator;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.maru.m4hv.extensions.constraints.Second;
import org.maru.m4hv.extensions.util.Condition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecondValidatorForNumber
implements ConstraintValidator<Second, Number> {
    private int startSecond;
    private int endSecond;
    private static final int MIN_SECOND = 0;
    private static final int MAX_SECOND = 59;

    public void initialize(Second second) {
        this.startSecond = Condition.checkIncludedCorrectRange(second.from(), 0, 59);
        this.endSecond = Condition.checkIncludedCorrectRange(second.until(), 0, 59);
        if (!Condition.isLessThan(this.startSecond, this.endSecond)) {
            throw new IllegalArgumentException("The start second [" + this.startSecond + "] must be less than the end second [" + this.startSecond + "]");
        }
    }

    public boolean isValid(Number object, ConstraintValidatorContext constraintContext) {
        Integer value;
        if (object == null) {
            return true;
        }
        if (object instanceof Integer) {
            value = (int)((Integer)object);
        } else if (object instanceof Byte) {
            Byte byteValue = (byte)((Byte)object);
            value = byteValue.intValue();
        } else if (object instanceof Short) {
            Short shortValue = (short)((Short)object);
            value = shortValue.intValue();
        } else {
            throw new IllegalArgumentException("Unexpected type : " + object.getClass().getName());
        }
        return Condition.isIncludedInRange(value, this.startSecond, this.endSecond);
    }
}

