/*
 * Decompiled with CFR 0.152.
 */
package org.maru.m4hv.extensions.validator;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.maru.m4hv.extensions.constraints.Minute;
import org.maru.m4hv.extensions.util.Condition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinuteValidatorForNumber
implements ConstraintValidator<Minute, Number> {
    private int startMinute;
    private int endMinute;
    private static final int MIN_MINUTE = 0;
    private static final int MAX_MINUTE = 59;

    public void initialize(Minute minute) {
        this.startMinute = Condition.checkIncludedCorrectRange(minute.from(), 0, 59);
        this.endMinute = Condition.checkIncludedCorrectRange(minute.until(), 0, 59);
        if (!Condition.isLessThan(this.startMinute, this.endMinute)) {
            throw new IllegalArgumentException("The start minute [" + this.startMinute + "] must be less than the end minute [" + this.endMinute + "]");
        }
    }

    public boolean isValid(Number object, ConstraintValidatorContext constraintContext) {
        Integer value;
        if (object == null) {
            return true;
        }
        if (object instanceof Integer) {
            value = (int)((Integer)object);
        } else if (object instanceof Byte) {
            Byte byteValue = (byte)((Byte)object);
            value = byteValue.intValue();
        } else if (object instanceof Short) {
            Short shortValue = (short)((Short)object);
            value = shortValue.intValue();
        } else {
            throw new IllegalArgumentException("Unexpected type : " + object.getClass().getName());
        }
        return Condition.isIncludedInRange(value, this.startMinute, this.endMinute);
    }
}

