/*
 * Decompiled with CFR 0.152.
 */
package org.maru.m4hv.extensions.validator;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.maru.m4hv.extensions.constraints.Hour;
import org.maru.m4hv.extensions.util.Condition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HourValidator
implements ConstraintValidator<Hour, Object> {
    private int startHour;
    private int endHour;
    private static final int MIN_HOUR = 0;
    private static final int MAX_HOUR = 23;

    public void initialize(Hour hour) {
        this.startHour = Condition.checkIncludedCorrectRange(hour.from(), 0, 23);
        this.endHour = Condition.checkIncludedCorrectRange(hour.until(), 0, 23);
        if (!Condition.isLessThan(this.startHour, this.endHour)) {
            throw new IllegalArgumentException("The start hour [" + this.startHour + "] must be less than the end hour [" + this.endHour + "]");
        }
    }

    public boolean isValid(Object object, ConstraintValidatorContext constraintContext) {
        Integer value;
        if (object == null) {
            return true;
        }
        if (object instanceof String) {
            value = Integer.valueOf((String)object);
        } else if (object instanceof Integer) {
            value = (Integer)object;
        } else {
            throw new IllegalArgumentException("Unexpected type : " + object.getClass().getName());
        }
        return Condition.isIncludedInRange(value, this.startHour, this.endHour);
    }
}

