/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.util;

import java.lang.reflect.Method;

/**
 * Method utility.
 *
 */
public final class MethodUtil {

    private MethodUtil(){}

    /**
     * check if method is JavaBeans style getter method.
     * @param name the name of the method.
     * @param method method
     * @return true if method is getter, otherwise false.
     */
    public static boolean isGetterMethod(String name, Method method) {
        if (name.startsWith("get")
                && method.getGenericParameterTypes().length == 0
                && !(method.getReturnType().equals(void.class))) {
            return true;
        }else if (name.startsWith("is")
                && method.getGenericParameterTypes().length == 0
                && (method.getReturnType().equals(boolean.class) || method.getReturnType().equals(Boolean.class))) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * check if method is JavaBeans style setter method
     * @param name the name of the method.
     * @param method method
     * @return true if method is setter, otherwise false.
     */
    public static boolean isSetterMethod(String name, Method method) {
        if (name.startsWith("set")
                && method.getGenericParameterTypes().length == 1
                && method.getReturnType().equals(void.class)) {
            return true;
        }
        return false;
    }
}
