/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.core;

import java.util.Arrays;

public final class Syntax {

    private Syntax() {}

    private static final Operator[][] MD_SYNTAX_ARRAY = {
        {Operator.BOUND, Operator.FROM},
        {Operator.BOUND, Operator.FROM, Operator.BIND},
        {Operator.BOUND, Operator.FROM, Operator.CONVERTER_OFF},
        {Operator.BOUND, Operator.FROM, Operator.BIND, Operator.CONVERTER_OFF},
        {Operator.BOUND, Operator.FROM, Operator.CONVERTER_OFF, Operator.BIND},
    };


    public static boolean checkSyntax(Operator... operators) {
        boolean correctSyntax = false;
        for (Operator[] mdSyntaxs : MD_SYNTAX_ARRAY) {
            if (operators.length == mdSyntaxs.length) {
                if (Arrays.equals(operators, mdSyntaxs)) {
                    correctSyntax = true;
                    break;
                }
            }
        }
        return correctSyntax;
    }

}
