/*
 * Copyright 2011 maru project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.maru.dog.core;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;

/**
 * This class indicates the marking point described by anything.
 *
 */
public abstract class MarkedPoint<T> {

    /** declaring class */
    protected Class<T> declaringClass;

    /** the name of the marked point */
    protected String name;

    protected Member member;

    public MarkedPoint() {
    }

    public MarkedPoint(Class<T> declaringClass, String name, Member member) {

        this.declaringClass = declaringClass;
        this.name = name;
        if (member instanceof Field) {
            ((Field) member).setAccessible(true);
        } else {
            ((Method)member).setAccessible(true);
        }
        this.member = member;
    }

    public Class<T> getDeclaringClass() {
        return declaringClass;
    }

    public void setDeclaringClass(Class<T> declaringClass) {
        this.declaringClass = declaringClass;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Member getMember() {
        return member;
    }

    public void setMember(Member member) {
        this.member = member;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();

        sb.append("MarkedPint [");
        sb.append("declaringClass=" + declaringClass.getName() + ", ");
        sb.append("member=" + member + ", ");
        sb.append("name=" + name + "]");
        return sb.toString();
    }

}
