package org.maru.dog.bind;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;

final class InputActualFieldNamePointBuilder<T> extends  AbstractInputMarkedPointBuilder<T> {

    InputActualFieldNamePointBuilder(Class<T> type) {
        super(type, new BindingDefinitionImpl<T>(type));
    }

    @Override
    protected InputMarkedPoint<T> getInputMarkedPoint(Member member, Class<T> target) {
        InputMarkedPoint<T> inputMarkedPoint = null;
        if (member instanceof Field) {
            Field f = (Field) member;

            String actualFieldName = f.getName();

            // check if converter annotation is defined.
            Annotation converterAnnotation = checkAndGetConverterClassAnnotation(f);
            ConverterDef converterDef = new ConverterDef();
            if (converterAnnotation != null) {
                converterDef = getConverterClassInformation(converterAnnotation, f.getGenericType());
                converterDef.verifyConverter();
            }

            // create marked point
            inputMarkedPoint = createInputMarkedPointInstance(target, actualFieldName, f, converterDef);

        }
        return inputMarkedPoint;
    }

}
